/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.translation.model.impl;

import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.TranslationEntryLocalServiceUtil;

/**
 * The extended model base implementation for the TranslationEntry service. Represents a row in the &quot;TranslationEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link TranslationEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TranslationEntryImpl
 * @see TranslationEntry
 * @generated
 */
public abstract class TranslationEntryBaseImpl
	extends TranslationEntryModelImpl implements TranslationEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a translation entry model instance should use the <code>TranslationEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			TranslationEntryLocalServiceUtil.addTranslationEntry(this);
		}
		else {
			TranslationEntryLocalServiceUtil.updateTranslationEntry(this);
		}
	}

}