/*===========================================================================
  Copyright (C) 2009-2019 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.common.annotation;

/**
 * An {@link IAnnotation} that can be serialized.
 * Must have a {@link #toString()} and {@link #fromString(String)}
 * methods to write and read themselves to and from a string.
 */
public interface IPersistentAnnotation extends IAnnotation {
    /**
     * Initializes this annotation from a storage string originally obtained
     * from {@link #toString()}.
     * @param storage The storage string to use for the initialization.
     */
    void fromString (String storage);

    /**
     * Clones this annotation.
     * @return A new {@link IPersistentAnnotation} object that is a copy of this one.
     */
    IPersistentAnnotation clone();
}
