/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.base.SyncDeviceLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.sync.model.SyncDevice"}, service={AopService.class})
public class SyncDeviceLocalServiceImpl
extends SyncDeviceLocalServiceBaseImpl {
    public SyncDevice addSyncDevice(long userId, String type, long buildNumber, String hostname, int featureSet) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        long syncDeviceId = this.counterLocalService.increment();
        SyncDevice syncDevice = this.syncDevicePersistence.create(syncDeviceId);
        syncDevice.setCompanyId(user.getCompanyId());
        syncDevice.setUserId(user.getUserId());
        syncDevice.setUserName(user.getFullName());
        syncDevice.setCreateDate(now);
        syncDevice.setModifiedDate(now);
        syncDevice.setType(type);
        syncDevice.setBuildNumber(buildNumber);
        syncDevice.setFeatureSet(featureSet);
        syncDevice.setHostname(hostname);
        syncDevice.setStatus(0);
        return (SyncDevice)this.syncDevicePersistence.update((BaseModel)syncDevice);
    }

    public List<SyncDevice> getSyncDevices(long userId, int start, int end, OrderByComparator<SyncDevice> orderByComparator) throws PortalException {
        return this.syncDevicePersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public List<SyncDevice> search(long companyId, String keywords, int start, int end, OrderByComparator<SyncDevice> orderByComparator) {
        return this.syncDevicePersistence.findByC_U(companyId, StringUtil.quote((String)keywords, (String)"%"), start, end, orderByComparator);
    }

    public void updateStatus(long syncDeviceId, int status) throws PortalException {
        SyncDevice syncDevice = this.syncDevicePersistence.findByPrimaryKey(syncDeviceId);
        syncDevice.setStatus(status);
        this.syncDevicePersistence.update((BaseModel)syncDevice);
    }

    public SyncDevice updateSyncDevice(long syncDeviceId, String type, long buildNumber, int featureSet, String hostname, int status) throws PortalException {
        SyncDevice syncDevice = this.syncDevicePersistence.findByPrimaryKey(syncDeviceId);
        syncDevice.setModifiedDate(new Date());
        syncDevice.setType(type);
        syncDevice.setBuildNumber(buildNumber);
        syncDevice.setFeatureSet(featureSet);
        syncDevice.setHostname(hostname);
        syncDevice.setStatus(status);
        return (SyncDevice)this.syncDevicePersistence.update((BaseModel)syncDevice);
    }
}

