/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.sync.model.SyncDLObject;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

@JSON
public class SyncDLObjectUpdate {
    private final long _lastAccessTime;
    private final int _resultsTotal;
    private final Map<String, Long> _settingsModifiedTimes;
    private final List<SyncDLObject> _syncDLObjects;

    public SyncDLObjectUpdate(List<SyncDLObject> syncDLObjects, int resultsTotal, long lastAccessTime) {
        this._syncDLObjects = syncDLObjects;
        this._resultsTotal = resultsTotal;
        this._lastAccessTime = lastAccessTime;
        this._settingsModifiedTimes = Collections.emptyMap();
    }

    public SyncDLObjectUpdate(List<SyncDLObject> syncDLObjects, int resultsTotal, long lastAccessTime, Map<String, Long> settingsModifiedTimes) {
        this._syncDLObjects = syncDLObjects;
        this._resultsTotal = resultsTotal;
        this._lastAccessTime = lastAccessTime;
        this._settingsModifiedTimes = settingsModifiedTimes;
    }

    public long getLastAccessTime() {
        return this._lastAccessTime;
    }

    public int getResultsTotal() {
        return this._resultsTotal;
    }

    public Map<String, Long> getSettingsModifiedTimes() {
        return this._settingsModifiedTimes;
    }

    @JSON
    public List<SyncDLObject> getSyncDLObjects() {
        return this._syncDLObjects;
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._settingsModifiedTimes.size() * 4 + this._syncDLObjects.size() * 80 + 5);
        sb.append("{\"lastAccessTime\":");
        this.append(sb, this._lastAccessTime, false);
        sb.append(",\"resultsTotal\":");
        sb.append(this._resultsTotal);
        sb.append(",\"settingsModifiedTimes\":{");
        Set<Map.Entry<String, Long>> entries = this._settingsModifiedTimes.entrySet();
        Iterator<Map.Entry<String, Long>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            this.append(sb, entry.getKey(), false);
            sb.append(":");
            this.append(sb, entry.getValue(), false);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("},\"syncDLObjects\":[");
        for (int i = 0; i < this._syncDLObjects.size(); ++i) {
            SyncDLObject syncDLObject = this._syncDLObjects.get(i);
            sb.append("{\"changeLog\":");
            this.append(sb, syncDLObject.getChangeLog(), true);
            sb.append(",\"checksum\":");
            this.append(sb, syncDLObject.getChecksum(), false);
            sb.append(",\"companyId\":");
            this.append(sb, syncDLObject.getCompanyId(), false);
            sb.append(",\"createTime\":");
            this.append(sb, syncDLObject.getCreateTime(), false);
            sb.append(",\"description\":");
            this.append(sb, syncDLObject.getDescription(), true);
            sb.append(",\"event\":");
            this.append(sb, syncDLObject.getEvent(), false);
            sb.append(",\"extension\":");
            this.append(sb, syncDLObject.getExtension(), true);
            sb.append(",\"extraSettings\":");
            this.append(sb, syncDLObject.getExtraSettings(), true);
            sb.append(",\"lanTokenKey\":");
            this.append(sb, syncDLObject.getLanTokenKey(), false);
            sb.append(",\"lockExpirationDate\":");
            Date lockExpirationDate = syncDLObject.getLockExpirationDate();
            if (lockExpirationDate != null) {
                sb.append(lockExpirationDate.getTime());
            } else {
                sb.append("null");
            }
            sb.append(",\"lockUserId\":");
            this.append(sb, syncDLObject.getLockUserId(), false);
            sb.append(",\"lockUserName\":");
            this.append(sb, syncDLObject.getLockUserName(), true);
            sb.append(",\"mimeType\":");
            this.append(sb, syncDLObject.getMimeType(), true);
            sb.append(",\"modifiedTime\":");
            this.append(sb, syncDLObject.getModifiedTime(), false);
            sb.append(",\"name\":");
            this.append(sb, syncDLObject.getName(), true);
            sb.append(",\"parentFolderId\":");
            this.append(sb, syncDLObject.getParentFolderId(), false);
            sb.append(",\"repositoryId\":");
            this.append(sb, syncDLObject.getRepositoryId(), false);
            sb.append(",\"size\":");
            this.append(sb, syncDLObject.getSize(), false);
            sb.append(",\"syncDLObjectId\":");
            this.append(sb, syncDLObject.getSyncDLObjectId(), false);
            sb.append(",\"type\":");
            this.append(sb, syncDLObject.getType(), false);
            sb.append(",\"typePK\":");
            this.append(sb, syncDLObject.getTypePK(), false);
            sb.append(",\"typeUuid\":");
            this.append(sb, syncDLObject.getTypeUuid(), false);
            sb.append(",\"userId\":");
            this.append(sb, syncDLObject.getUserId(), false);
            sb.append(",\"userName\":");
            this.append(sb, syncDLObject.getUserName(), true);
            sb.append(",\"version\":");
            this.append(sb, syncDLObject.getVersion(), false);
            sb.append(",\"versionId\":");
            this.append(sb, syncDLObject.getVersionId(), false);
            sb.append("}");
            if (i == this._syncDLObjects.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }

    protected void append(StringBundler sb, Object s, boolean escape) {
        sb.append("\"");
        if (escape) {
            s = StringEscapeUtils.escapeJava((String)String.valueOf(s));
        }
        sb.append(s);
        sb.append("\"");
    }
}

