/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.internal.model.listener;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class SubscriptionPortletPreferencesModelListener
extends BaseModelListener<PortletPreferences> {
    private static final Log _log = LogFactoryUtil.getLog(SubscriptionPortletPreferencesModelListener.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void onAfterRemove(PortletPreferences portletPreferences) {
        this.deleteSubscriptions(portletPreferences);
    }

    protected void deleteSubscriptions(PortletPreferences portletPreferences) {
        if (portletPreferences == null) {
            return;
        }
        try {
            if (!CopyLayoutThreadLocal.isCopyLayout()) {
                this._subscriptionLocalService.deleteSubscriptions(portletPreferences.getCompanyId(), portletPreferences.getModelClassName(), portletPreferences.getPortletPreferencesId());
                return;
            }
            TransactionCommitCallbackUtil.registerCallback(() -> {
                PortletPreferences remainingPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), portletPreferences.getPlid(), portletPreferences.getPortletId());
                if (remainingPortletPreferences == null) {
                    this._subscriptionLocalService.deleteSubscriptions(portletPreferences.getCompanyId(), portletPreferences.getModelClassName(), portletPreferences.getPortletPreferencesId());
                    return null;
                }
                this._subscriptionLocalService.updateSubscriptions(remainingPortletPreferences.getCompanyId(), this._classNameLocalService.getClassNameId(remainingPortletPreferences.getModelClassName()), portletPreferences.getPortletPreferencesId(), remainingPortletPreferences.getPortletPreferencesId());
                return null;
            });
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to delete subscriptions", (Throwable)exception);
        }
    }
}

