/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class UnsyncCharArrayReader
extends Reader {
    private char[] _buffer;
    private final int _capacity;
    private int _index;
    private int _markIndex;

    public UnsyncCharArrayReader(char[] chars) {
        this._buffer = chars;
        this._capacity = chars.length;
        this._index = 0;
    }

    public UnsyncCharArrayReader(char[] chars, int offset, int length) {
        this._buffer = chars;
        this._index = offset;
        this._markIndex = offset;
        this._capacity = Math.min(chars.length, offset + length);
    }

    @Override
    public void close() {
        this._buffer = null;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        this._markIndex = this._index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        if (this._index >= this._capacity) {
            return -1;
        }
        return this._buffer[this._index++];
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        BoundaryCheckerUtil.check(chars.length, offset, length);
        if (this._index >= this._capacity) {
            return -1;
        }
        int read = length;
        if (this._index + read > this._capacity) {
            read = this._capacity - this._index;
        }
        System.arraycopy(this._buffer, this._index, chars, offset, read);
        this._index += read;
        return read;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        int length = charBuffer.remaining();
        if (length <= 0) {
            return 0;
        }
        if (this._index >= this._capacity) {
            return -1;
        }
        if (this._index + length > this._capacity) {
            length = this._capacity - this._index;
        }
        charBuffer.put(this._buffer, this._index, length);
        this._index += length;
        return length;
    }

    @Override
    public boolean ready() throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        return this._capacity > this._index;
    }

    @Override
    public void reset() throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        this._index = this._markIndex;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (this._buffer == null) {
            throw new IOException("Stream closed");
        }
        if (skip < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        if ((long)this._index + skip > (long)this._capacity) {
            skip = this._capacity - this._index;
        }
        this._index = (int)((long)this._index + skip);
        return skip;
    }
}

