/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JsonSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiIndentationCheck
extends BaseFileCheck {
    private static final Pattern _tripleQuotesPattern = Pattern.compile("(?:\n)(\t+)(var )?(\\w+) = '''(.+?)'''[,;)]", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixTripleQuotesIndentation(content);
    }

    private String _fixCurlIndentation(String tripleQuotesContent, String indent) {
        String trimmedContent = tripleQuotesContent.trim();
        String[] lines = trimmedContent.split("\n");
        if (lines.length < 2) {
            return tripleQuotesContent;
        }
        int leadingTabCount = indent.length();
        lines[0] = this._fixTabs(leadingTabCount + 1, lines[0]);
        int level = leadingTabCount + 2;
        for (int i = 1; i < lines.length; ++i) {
            String trimmedLine = StringUtil.trim(lines[i]);
            lines[i] = this._fixTabs(level, trimmedLine);
            trimmedLine = trimmedLine.replaceAll("(.*?)\\$\\{.*?\\}(.*)", "$1$2");
            level += this.getLevel(trimmedLine, "[{", "}]");
            trimmedLine = StringUtil.removeSubstrings(trimmedLine, "[{", "}]");
            level += this.getLevel(trimmedLine, new String[]{"[", "{"}, new String[]{"]", "}"});
            if (!trimmedLine.endsWith("'{")) continue;
            ++level;
        }
        StringBundler sb = new StringBundler(lines.length * 2 + 2);
        for (String line : lines) {
            sb.append('\n');
            sb.append(line);
        }
        sb.append('\n');
        sb.append(indent);
        return this._formatJSONInCurl(sb.toString());
    }

    private String _fixTableIndentation(String tripleQuotesContent, String indent) {
        String trimmedContent = tripleQuotesContent.trim();
        if (!trimmedContent.startsWith("|") && !trimmedContent.endsWith("|")) {
            return tripleQuotesContent;
        }
        String[] lines = trimmedContent.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (Validator.isNull(lines[i])) continue;
            String trimmedLine = StringUtil.trim(lines[i]);
            if (!trimmedLine.startsWith("|") || !trimmedLine.endsWith("|")) {
                return tripleQuotesContent;
            }
            lines[i] = indent + "\t" + trimmedLine;
        }
        StringBundler sb = new StringBundler(lines.length * 2 + 2);
        for (String line : lines) {
            sb.append('\n');
            sb.append(line);
        }
        sb.append('\n');
        sb.append(indent);
        return sb.toString();
    }

    private String _fixTabs(int expectedTabCount, String line) {
        if (line.equals("]") || line.equals("]'") || line.equals("],") || line.equals("}") || line.equals("}'") || line.equals("},") || line.equals("}]") || line.equals("}]'") || line.equals("}],")) {
            --expectedTabCount;
        }
        StringBundler sb = new StringBundler(expectedTabCount + 1);
        for (int i = 0; i < expectedTabCount; ++i) {
            sb.append('\t');
        }
        sb.append(StringUtil.trim(line));
        return sb.toString();
    }

    private String _fixTripleQuotesIndentation(String content) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _tripleQuotesPattern.matcher(content);
        while (matcher.find()) {
            String replacement = null;
            String variableName = matcher.group(3);
            if (variableName.matches("(?i)\\w*curl")) {
                replacement = this._fixCurlIndentation(matcher.group(4), matcher.group(1));
            } else if (variableName.equals("table")) {
                replacement = this._fixTableIndentation(matcher.group(4), matcher.group(1));
            }
            if (replacement == null || StringUtil.equals(matcher.group(4), replacement)) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(StringUtil.replaceFirst(matcher.group(), matcher.group(4), replacement)));
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    private String _formatJSONInCurl(String content) {
        String s;
        int level;
        int x = content.indexOf("-d '{");
        if (x == -1) {
            return content;
        }
        int y = x;
        do {
            if ((y = content.indexOf("}", y + 1)) != -1) continue;
            return content;
        } while (ToolsUtil.isInsideQuotes(content, y) || (level = this.getLevel(s = content.substring(x + 4, y + 1), "{", "}")) != 0);
        JSONObject jsonObject = JsonSourceUtil.getJSONObject(s);
        if (jsonObject != null) {
            int lineNumber = SourceUtil.getLineNumber(content, x);
            String replacement = JsonSourceUtil.fixIndentation(jsonObject, SourceUtil.getIndent(SourceUtil.getLine(content, lineNumber)));
            if (!s.equals(replacement = StringUtil.trim(replacement))) {
                return StringUtil.replaceFirst(content, s, replacement, x);
            }
        }
        return content;
    }
}

