/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import com.liferay.petra.string.StringBundler;
import java.io.IOException;
import java.io.Reader;

public class UnsyncBufferedReader
extends Reader {
    private static final int _DEFAULT_BUFFER_SIZE = 8192;
    private char[] _buffer;
    private int _firstInvalidIndex;
    private int _index;
    private int _markLimitIndex = -1;
    private Reader _reader;

    public UnsyncBufferedReader(Reader reader) {
        this(reader, 8192);
    }

    public UnsyncBufferedReader(Reader reader, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 1");
        }
        this._reader = reader;
        this._buffer = new char[size];
    }

    @Override
    public void close() throws IOException {
        if (this._reader != null) {
            this._reader.close();
            this._reader = null;
            this._buffer = null;
        }
    }

    @Override
    public void mark(int markLimit) throws IOException {
        if (markLimit < 0) {
            throw new IllegalArgumentException("Mark limit is less than 0");
        }
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        if (markLimit == 0) {
            return;
        }
        this._markLimitIndex = markLimit;
        if (this._index == 0) {
            return;
        }
        int available = this._firstInvalidIndex - this._index;
        if (available > 0) {
            System.arraycopy(this._buffer, this._index, this._buffer, 0, available);
            this._index = 0;
            this._firstInvalidIndex = available;
        } else {
            this._firstInvalidIndex = 0;
            this._index = 0;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        if (this._index >= this._firstInvalidIndex) {
            this._fillInBuffer();
            if (this._index >= this._firstInvalidIndex) {
                return -1;
            }
        }
        return this._buffer[this._index++];
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        int currentRead;
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        BoundaryCheckerUtil.check(chars.length, offset, length);
        if (length == 0) {
            return 0;
        }
        int read = 0;
        do {
            if ((currentRead = this._readOnce(chars, offset + read, length - read)) > 0) continue;
            if (read != 0) break;
            read = currentRead;
            break;
        } while (this._reader.ready() && (read += currentRead) < length);
        return read;
    }

    public String readLine() throws IOException {
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        StringBundler sb = null;
        while (true) {
            int y;
            if (this._index >= this._firstInvalidIndex) {
                this._fillInBuffer();
            }
            if (this._index >= this._firstInvalidIndex) {
                if (sb == null) {
                    return null;
                }
                return sb.toString();
            }
            boolean hasLineBreak = false;
            char lineEndChar = '\u0000';
            int x = this._index;
            for (y = this._index; y < this._firstInvalidIndex; ++y) {
                lineEndChar = this._buffer[y];
                if (lineEndChar != '\n' && lineEndChar != '\r') continue;
                hasLineBreak = true;
                break;
            }
            String line = new String(this._buffer, x, y - x);
            this._index = y;
            if (hasLineBreak) {
                ++this._index;
                if (lineEndChar == '\r' && this._index < this._buffer.length && this._buffer[this._index] == '\n') {
                    ++this._index;
                }
                if (sb == null) {
                    return line;
                }
                sb.append(line);
                return sb.toString();
            }
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(line);
        }
    }

    @Override
    public boolean ready() throws IOException {
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        return this._index < this._firstInvalidIndex || this._reader.ready();
    }

    @Override
    public void reset() throws IOException {
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        if (this._markLimitIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this._index = 0;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip is less than 0");
        }
        if (this._reader == null) {
            throw new IOException("Reader is null");
        }
        if (skip == 0L) {
            return 0L;
        }
        long available = this._firstInvalidIndex - this._index;
        if (available <= 0L) {
            if (this._markLimitIndex < 0) {
                return this._reader.skip(skip);
            }
            this._fillInBuffer();
            available = this._firstInvalidIndex - this._index;
            if (available <= 0L) {
                return 0L;
            }
        }
        if (available < skip) {
            skip = available;
        }
        this._index = (int)((long)this._index + skip);
        return skip;
    }

    private void _fillInBuffer() throws IOException {
        if (this._markLimitIndex < 0) {
            this._firstInvalidIndex = 0;
            this._index = 0;
            int number = this._reader.read(this._buffer);
            if (number > 0) {
                this._firstInvalidIndex = number;
            }
            return;
        }
        if (this._index >= this._markLimitIndex) {
            this._markLimitIndex = -1;
            this._firstInvalidIndex = 0;
            this._index = 0;
        } else if (this._index == this._buffer.length) {
            int newBufferSize = this._buffer.length * 2;
            if (newBufferSize > this._markLimitIndex) {
                newBufferSize = this._markLimitIndex;
            }
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._buffer.length);
            this._buffer = newBuffer;
        }
        this._firstInvalidIndex = this._index;
        int number = this._reader.read(this._buffer, this._index, this._buffer.length - this._index);
        if (number > 0) {
            this._firstInvalidIndex += number;
        }
    }

    private int _readOnce(char[] chars, int offset, int length) throws IOException {
        int available = this._firstInvalidIndex - this._index;
        if (available <= 0) {
            if (this._markLimitIndex < 0 && length >= this._buffer.length) {
                return this._reader.read(chars, offset, length);
            }
            this._fillInBuffer();
            available = this._firstInvalidIndex - this._index;
            if (available <= 0) {
                return -1;
            }
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this._buffer, this._index, chars, offset, length);
        this._index += length;
        return length;
    }
}

