/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@StatelessCheck
public final class UnnecessarySemicolonInEnumerationCheck
extends AbstractCheck {
    public static final String MSG_SEMI = "unnecessary.semicolon";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{154};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST enumBlock = ast.findFirstToken(6);
        DetailAST semicolon = enumBlock.findFirstToken(45);
        if (semicolon != null && UnnecessarySemicolonInEnumerationCheck.isEndOfEnumerationAfter(semicolon)) {
            this.log(semicolon, MSG_SEMI, new Object[0]);
        }
    }

    private static boolean isEndOfEnumerationAfter(DetailAST ast) {
        return ast.getNextSibling().getType() == 73;
    }
}

