/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaNewProblemInstantiationParametersCheck
extends BaseJavaTermCheck {
    private static final Pattern _newProblemPattern = Pattern.compile("new Problem\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        List<String> importNames = javaTerm.getImportNames();
        String javaTermContent = javaTerm.getContent();
        if (!importNames.contains("com.liferay.portal.vulcan.jaxrs.exception.mapper.Problem")) {
            return javaTermContent;
        }
        Matcher matcher = _newProblemPattern.matcher(javaTermContent);
        while (matcher.find()) {
            String variableTypeName;
            String parameterName;
            String methodCall = JavaSourceUtil.getMethodCall(javaTermContent, matcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            parameterList.replaceAll(parameter -> parameter.replaceAll("\n\t*", ""));
            String exceptionVariableName = null;
            if (parameterList.size() == 2) {
                parameterName = parameterList.get(1);
                if (StringUtil.equals(parameterList.get(0), "Response.Status.BAD_REQUEST") && parameterName.matches("\\w*[eE]xception\\.getMessage\\(\\)")) {
                    exceptionVariableName = parameterName.substring(0, parameterName.indexOf("."));
                }
            } else if (parameterList.size() == 4) {
                parameterName = parameterList.get(2);
                if (StringUtil.equals(parameterList.get(0), "null") && StringUtil.equals(parameterList.get(1), "Response.Status.BAD_REQUEST") && parameterName.matches("\\w*[eE]xception\\.getMessage\\(\\)")) {
                    exceptionVariableName = parameterName.substring(0, parameterName.indexOf("."));
                }
            }
            if (exceptionVariableName == null || (variableTypeName = this.getVariableTypeName(javaTermContent, javaTerm, fileContent, fileName, exceptionVariableName)) == null || !variableTypeName.endsWith("Exception") || parameterList.size() == 4 && !StringUtil.equals(parameterList.get(3), variableTypeName + ".class.getSimpleName()")) continue;
            return StringUtil.replaceFirst(javaTermContent, methodCall, "new Problem(" + exceptionVariableName + ")", matcher.start());
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }
}

