/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.SourceCheck;
import com.liferay.source.formatter.processor.BaseSourceProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/templates/*.tpl", "**/*.yaml", "**/*.yml"};
    private static final Pattern _dashPattern = Pattern.compile("( +- +)(.+)");

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        HashSet<String> modifiedContents = new HashSet<String>();
        TreeSet<String> modifiedMessages = new TreeSet<String>();
        String newContent = this._preProcess(content);
        newContent = this.format(file, fileName, absolutePath, newContent, content, new ArrayList<SourceCheck>(this.getSourceChecks()), modifiedContents, modifiedMessages, 0);
        newContent = this._postProcess(newContent);
        return this.processFormattedFile(file, fileName, content, newContent, modifiedMessages);
    }

    private String _postProcess(String content) {
        content = content.replaceAll("(?m)^( *-)\n +(.*)", "$1   $2");
        return content.replaceAll("\\n +\\n", "\n\n");
    }

    private String _preProcess(String content) {
        String[] lines;
        content = content.replaceAll("\\n +\\n", "\n\n");
        StringBundler sb = new StringBundler();
        for (String line : lines = content.split("\n")) {
            String trimmedLine = line.trim();
            if (Validator.isBlank(trimmedLine)) {
                sb.append("\n");
                continue;
            }
            Matcher matcher = _dashPattern.matcher(line);
            if (matcher.matches()) {
                String indent = matcher.group(1);
                sb.append(StringUtil.trimTrailing(indent));
                sb.append("\n");
                sb.append(indent.replaceFirst("-", " "));
                sb.append(matcher.group(2));
                sb.append("\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

