/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.Objects;

public class TestClassMissingLiferayUnitTestRuleCheck
extends BaseCheck {
    private static final String _MSG_REQUIRE_TEST_RULE = "test.rule.missing";
    private static final String _PAHT_NAMES_WHITELIST = "pathNamesWhitelist";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.contains("/test/") || !absolutePath.endsWith("Test.java") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        List<String> pathNames = this.getAttributeValues(_PAHT_NAMES_WHITELIST);
        for (String pathName : pathNames) {
            DetailAST literalClassDetailAST2;
            if (!absolutePath.contains(pathName)) continue;
            DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"RunWith");
            if (annotationDetailAST != null) {
                List<DetailAST> literalClassDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 69);
                for (DetailAST literalClassDetailAST2 : literalClassDetailASTList) {
                    DetailAST identDetailAST = literalClassDetailAST2.getPreviousSibling();
                    String className = identDetailAST.getText();
                    if (!className.equals("MockitoJUnitRunner") && !className.equals("PowerMockRunner")) continue;
                    return;
                }
            }
            DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
            List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 10);
            literalClassDetailAST2 = variableDefinitionDetailASTList.iterator();
            while (literalClassDetailAST2.hasNext()) {
                DetailAST variableDefinitionDetailAST = (DetailAST)literalClassDetailAST2.next();
                DetailAST typeDetailAST = variableDefinitionDetailAST.findFirstToken(13);
                DetailAST identDetailAST = typeDetailAST.getFirstChild();
                if (identDetailAST.getType() != 58) continue;
                String variableType = identDetailAST.getText();
                if (variableType.equals("LiferayUnitTestRule")) {
                    return;
                }
                List<DetailAST> dotDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 59);
                FullIdent fullIdent = null;
                for (DetailAST dotDetailAST : dotDetailASTList) {
                    fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST);
                    if (!Objects.equals(fullIdent.getText(), "LiferayUnitTestRule.INSTANCE")) continue;
                    return;
                }
            }
            List<String> importNames = this.getImportNames(detailAST);
            if (importNames.contains("com.liferay.portal.test.rule.LiferayUnitTestRule")) continue;
            this.log(detailAST, _MSG_REQUIRE_TEST_RULE, new Object[0]);
        }
    }
}

