/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaFacetedSearcherCheck
extends BaseUpgradeCheck {
    private static final Pattern _facetedSearcherGetInstancePattern = Pattern.compile("Indexer[<\\?>]*\\s+(\\w+)\\s*=\\s*\\s*FacetedSearcher\\s*\\.\\s*getInstance\\(\\);");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            String javaMethodContent;
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String newJavaMethodContent = javaMethodContent = javaMethod.getContent();
            Matcher matcher = _facetedSearcherGetInstancePattern.matcher(javaMethodContent);
            while (matcher.find()) {
                String methodCall = matcher.group(0);
                newJavaMethodContent = StringUtil.replace(newJavaMethodContent, methodCall, "FacetedSearcher facetedSearcher = FacetedSearcherManagerUtil.createFacetedSearcher();");
                newJavaMethodContent = StringUtil.replace(newJavaMethodContent, matcher.group(1) + ".search(", "facetedSearcher.search(");
            }
            content = StringUtil.replace(content, javaMethodContent, newJavaMethodContent);
        }
        return content;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManagerUtil"};
    }
}

