/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;

public class OSGiCommandsCheck
extends BaseCheck {
    private static final String _MSG_AVOID_OSGI_REFERENCE = "osgi.reference.avoid";
    private static final String _MSG_INCORRECT_CLASS_NAME = "class.name.incorrect";
    private static final String _MSG_INCORRECT_PUBLIC_METHOD_NAME = "public.method.name.incorrect";
    private static final String _MSG_MISSING_IMPLEMENTED_COMMAND_FUNCTION = "implemented.command.function.missing";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST implementsClauseDetailAST = detailAST.findFirstToken(19);
        if (implementsClauseDetailAST == null) {
            return;
        }
        List<String> implementedClassNames = this.getNames(implementsClauseDetailAST, false);
        if (!implementedClassNames.contains("OSGiCommands")) {
            return;
        }
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        if (objBlockDetailAST == null) {
            return;
        }
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST annotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (annotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = annotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        List<String> osgiCommandScopes = this._getProperties(annotationArrayInitDetailAST, "osgi.command.scope");
        if (osgiCommandScopes.isEmpty() || osgiCommandScopes.size() != 1) {
            return;
        }
        this._checkClassName(detailAST, osgiCommandScopes.get(0));
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        methodDefinitionDetailASTList = ListUtil.filter(methodDefinitionDetailASTList, methodDefinitionDetailAST -> {
            DetailAST modifiersDetailAST = methodDefinitionDetailAST.findFirstToken(5);
            return modifiersDetailAST.branchContains(62);
        });
        List<String> osgiCommandFunctions = this._getProperties(annotationArrayInitDetailAST, "osgi.command.function");
        this._checkIncorrectPublicMethodName(methodDefinitionDetailASTList, osgiCommandFunctions);
        this._checkMissingUnimplementedMethod(detailAST, methodDefinitionDetailASTList, osgiCommandFunctions);
        if (importNames.contains("org.osgi.service.component.annotations.Reference")) {
            this._checkVariableDeclaration(objBlockDetailAST);
        }
    }

    private void _checkClassName(DetailAST detailAST, String osgiCommandScope) {
        String className = this.getName(detailAST);
        if (!StringUtil.equalsIgnoreCase(className, osgiCommandScope + "OSGiCommands")) {
            this.log(detailAST, _MSG_INCORRECT_CLASS_NAME, new Object[0]);
        }
    }

    private void _checkIncorrectPublicMethodName(List<DetailAST> methodDefinitionDetailASTList, List<String> osgiCommandFunctions) {
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            String methodName = this.getName(methodDefinitionDetailAST);
            if (osgiCommandFunctions.contains(methodName)) continue;
            this.log(methodDefinitionDetailAST, _MSG_INCORRECT_PUBLIC_METHOD_NAME, new Object[0]);
        }
    }

    private void _checkMissingUnimplementedMethod(DetailAST detailAST, List<DetailAST> methodDefinitionDetailASTList, List<String> osgiCommandFunctions) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            String methodName = this.getName(methodDefinitionDetailAST);
            if (methodNames.contains(methodName)) continue;
            methodNames.add(methodName);
        }
        for (String osgiCommandFunction : osgiCommandFunctions) {
            if (methodNames.contains(osgiCommandFunction)) continue;
            this.log(detailAST, _MSG_MISSING_IMPLEMENTED_COMMAND_FUNCTION, new Object[]{osgiCommandFunction});
        }
    }

    private void _checkVariableDeclaration(DetailAST detailAST) {
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(detailAST, false, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            String typeName;
            if (!AnnotationUtil.containsAnnotation((DetailAST)variableDefinitionDetailAST, (String)"Reference") || !(typeName = this.getTypeName(variableDefinitionDetailAST, false)).endsWith("OSGiCommands")) continue;
            this.log(variableDefinitionDetailAST, _MSG_AVOID_OSGI_REFERENCE, new Object[0]);
        }
    }

    private List<String> _getProperties(DetailAST detailAST, String name) {
        ArrayList<String> osgiCommandProperties = new ArrayList<String>();
        for (DetailAST expressionDetailAST : this.getAllChildTokens(detailAST, false, 28)) {
            String[] property;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(property = StringUtil.split(StringUtil.unquote(firstChildDetailAST.getText()), '='))[0].equals(name)) continue;
            osgiCommandProperties.add(property[1]);
        }
        return osgiCommandProperties;
    }
}

