/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSnapshotClassNameCheck
extends BaseFileCheck {
    private static final Pattern _snapshotPattern = Pattern.compile("\n\tprivate static final Snapshot<.+>\\s+\\w+\\s+=\\s+new Snapshot<>\\(\\s*([\\w\\s.]+)\\.class");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _snapshotPattern.matcher(content);
        while (matcher.find()) {
            String className = JavaSourceUtil.getClassName(fileName);
            String holderClassName = matcher.group(1);
            if (holderClassName.equals(className)) continue;
            String replacement = StringUtil.replaceFirst(matcher.group(), holderClassName + ".class", className + ".class");
            matcher.appendReplacement(sb, replacement);
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }
}

