/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import java.io.Writer;

public class UnsyncStringWriter
extends Writer {
    private StringBuilder _stringBuilder;
    private StringBundler _stringBundler;

    public UnsyncStringWriter() {
        this(true);
    }

    public UnsyncStringWriter(boolean useStringBundler) {
        if (useStringBundler) {
            this._stringBundler = new StringBundler();
        } else {
            this._stringBuilder = new StringBuilder();
        }
    }

    public UnsyncStringWriter(boolean useStringBundler, int initialCapacity) {
        if (useStringBundler) {
            this._stringBundler = new StringBundler(initialCapacity);
        } else {
            this._stringBuilder = new StringBuilder(initialCapacity);
        }
    }

    public UnsyncStringWriter(int initialCapacity) {
        this(true, initialCapacity);
    }

    @Override
    public UnsyncStringWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public UnsyncStringWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public UnsyncStringWriter append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        charSequence = charSequence.subSequence(start, end);
        this.write(charSequence.toString());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public StringBuilder getStringBuilder() {
        return this._stringBuilder;
    }

    public StringBundler getStringBundler() {
        return this._stringBundler;
    }

    public void reset() {
        if (this._stringBundler != null) {
            this._stringBundler.setIndex(0);
        } else {
            this._stringBuilder.setLength(0);
        }
    }

    public String toString() {
        if (this._stringBundler != null) {
            return this._stringBundler.toString();
        }
        return this._stringBuilder.toString();
    }

    @Override
    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    @Override
    public void write(char[] chars, int offset, int length) {
        BoundaryCheckerUtil.check(chars.length, offset, length);
        if (length == 0) {
            return;
        }
        if (this._stringBundler != null) {
            this._stringBundler.append(new String(chars, offset, length));
        } else {
            this._stringBuilder.append(chars, offset, length);
        }
    }

    @Override
    public void write(int c) {
        if (this._stringBundler != null) {
            char ch = (char)c;
            if (ch <= '\u007f') {
                this._stringBundler.append(StringPool.ASCII_TABLE[ch]);
            } else {
                this._stringBundler.append(String.valueOf(ch));
            }
        } else {
            this._stringBuilder.append((char)c);
        }
    }

    @Override
    public void write(String string) {
        if (this._stringBundler != null) {
            this._stringBundler.append(string);
        } else {
            this._stringBuilder.append(string);
        }
    }

    @Override
    public void write(String string, int offset, int length) {
        if (string == null || offset == 0 && length == string.length()) {
            this.write(string);
        } else if (this._stringBundler != null) {
            this._stringBundler.append(string.substring(offset, offset + length));
        } else {
            this._stringBuilder.append(string.substring(offset, offset + length));
        }
    }
}

