/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullnode;

import java.io.IOException;
import java.util.Enumeration;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullNode;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.node.Node;
import org.gjt.xpp.impl.pullnode.PullNodeEnumerator;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;

public class PullNode
extends Node
implements XmlPullNode {
    protected int depth;
    protected XmlPullParser pp;

    public PullNode(XmlPullParser pp) throws XmlPullParserException {
        this.setPullParser(pp);
    }

    public XmlNode newNode() throws XmlPullParserException {
        return new PullNode(null);
    }

    public XmlPullNode newPullNode(XmlPullParser pp) throws XmlPullParserException {
        return new PullNode(pp);
    }

    public void resetPullNode() {
        if (this.pp != null) {
            this.readChildrenFullySafe(Integer.MAX_VALUE);
        }
        super.resetNode();
        this.depth = -1;
    }

    public boolean isFinished() {
        return this.pp == null;
    }

    public XmlPullParser getPullParser() throws IOException, XmlPullParserException {
        if (this.pp == null) {
            throw new XmlPullParserException("Pull node is complete and no pull parser can be returned");
        }
        int currentDepth = this.pp.getDepth();
        if (currentDepth >= this.depth + 1) {
            Object lastChild = this.getChildAt(this.childrenCount - 1);
            if (lastChild instanceof XmlPullNode) {
                ((XmlPullNode)lastChild).readChildren();
                currentDepth = this.pp.getDepth();
            } else {
                throw new XmlPullParserException("underlying pull parser is in incosistent state depth is " + currentDepth + " instead of " + this.depth + this.pp.getPosDesc());
            }
        }
        if (currentDepth == this.depth + 1) {
            if (this.pp.getEventType() != 3) {
                throw new XmlPullParserException("underlying pull parser is in incosistent state  it should be on end tag of last node  but it is at " + this.pp.getPosDesc());
            }
        } else if (currentDepth == this.depth) {
            if (this.pp.getEventType() != 2) {
                throw new XmlPullParserException("underlying pull parser is in incosistent state  it should be on start tag of this node " + this.getRawName() + " but it is at " + this.pp.getPosDesc());
            }
        } else {
            throw new XmlPullParserException("underlying pull parser is in incosistent state  it is above current node " + this.getRawName() + " currently at " + this.pp.getPosDesc());
        }
        XmlPullParser hold = this.pp;
        this.pp = null;
        return hold;
    }

    public void setPullParser(XmlPullParser pp) throws XmlPullParserException {
        super.resetNode();
        this.pp = pp;
        this.depth = -1;
        if (pp == null) {
            return;
        }
        if (pp.getEventType() != 2) {
            throw new XmlPullParserException("parser must be at START_TAG to create pull node" + pp.getPosDesc());
        }
        this.depth = pp.getDepth();
        pp.readNodeWithoutChildren(this);
    }

    public Enumeration children() {
        if (this.pp != null) {
            return new PullNodeEnumerator(this);
        }
        return super.children();
    }

    public Object readNextChild() throws XmlPullParserException, IOException {
        byte state;
        Object lastChild;
        if (this.pp == null) {
            return null;
        }
        if (this.childrenCount > 0 && (lastChild = this.getChildAt(this.childrenCount - 1)) instanceof XmlPullNode) {
            ((XmlPullNode)lastChild).readChildren();
        }
        if ((state = this.pp.next()) == 2) {
            if (this.pp.getDepth() != this.depth + 1) {
                throw new XmlPullParserException("expected start tag at depth " + (this.depth + 1) + " not " + this.pp.getDepth() + this.pp.getPosDesc());
            }
            XmlPullNode newChild = this.newPullNode(this.pp);
            super.appendChild(newChild);
            return newChild;
        }
        if (state == 4) {
            if (this.pp.getDepth() != this.depth) {
                throw new XmlPullParserException("expected content at depth " + this.depth + " not " + this.pp.getDepth() + this.pp.getPosDesc());
            }
            String content = this.pp.readContent();
            super.appendChild(content);
            return content;
        }
        if (state == 3) {
            if (this.pp.getDepth() != this.depth) {
                throw new XmlPullParserException("expected end tag at depth " + this.depth + " not " + this.pp.getDepth() + this.pp.getPosDesc());
            }
            this.pp = null;
            return null;
        }
        if (state == 1) {
            throw new XmlPullParserException("pull node could not be built -  embedded pull parser was accessed and already finished parsing" + this.pp.getPosDesc());
        }
        throw new XmlPullParserException("unexpected pull parser event " + state + this.pp.getPosDesc());
    }

    public void readChildren() throws XmlPullParserException, IOException {
        this.readChildren(Integer.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    private void readChildren(int pos) throws XmlPullParserException, IOException {
        if (this.pp != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            if (this.readNextChild() != null) continue;
            this.pp = null;
            break;
lbl6:
            // 2 sources

            ** while (this.childrenCount - 1 < pos)
        }
lbl7:
        // 2 sources

    }

    private void readChildrenFullySafe(int pos) {
        if (this.pp == null) {
            return;
        }
        try {
            Object lastChild;
            this.readChildren(pos);
            if (this.pp != null && this.childrenCount > 0 && (lastChild = this.getChildAt(this.childrenCount - 1)) instanceof XmlPullNode) {
                ((XmlPullNode)lastChild).readChildren();
            }
        }
        catch (XmlPullParserException ex) {
            throw new PullParserRuntimeException(ex);
        }
        catch (IOException ex) {
            throw new PullParserRuntimeException(ex);
        }
    }

    private void readChildrenPartialSafe(int pos) {
        try {
            this.readChildren(pos);
        }
        catch (XmlPullParserException ex) {
            throw new PullParserRuntimeException(ex);
        }
        catch (IOException ex) {
            throw new PullParserRuntimeException(ex);
        }
    }

    public void skipChildren() throws XmlPullParserException, IOException {
        byte event;
        Object lastChild;
        if (this.pp == null) {
            return;
        }
        if (this.childrenCount > 0 && (lastChild = this.getChildAt(this.childrenCount - 1)) instanceof XmlPullNode) {
            ((XmlPullNode)lastChild).skipChildren();
        }
        while (true) {
            if ((event = this.pp.next()) == 2) {
                if (this.pp.getDepth() != this.depth + 1) {
                    throw new XmlPullParserException("expected start tag at depth " + (this.depth + 1) + " not " + this.pp.getDepth() + this.pp.getPosDesc());
                }
                this.pp.skipNode();
                continue;
            }
            if (event != 4) break;
        }
        if (event == 3) {
            if (this.pp.getDepth() != this.depth) {
                throw new XmlPullParserException("expected end tag at depth " + this.depth + " not " + this.pp.getDepth() + this.pp.getPosDesc());
            }
        } else {
            throw new XmlPullParserException("unexpected parser event " + event + this.pp.getPosDesc());
        }
        this.pp = null;
        this.pp = null;
    }

    public int getChildrenCountSoFar() {
        return this.childrenCount;
    }

    public int getChildrenCount() {
        if (this.pp != null) {
            this.readChildrenFullySafe(Integer.MAX_VALUE);
        }
        return this.childrenCount;
    }

    public Object getChildAt(int pos) {
        if (this.pp != null && pos >= this.childrenCount) {
            this.readChildrenPartialSafe(pos);
        }
        return super.getChildAt(pos);
    }

    public void appendChild(Object child) throws XmlPullParserException {
        if (this.pp != null) {
            this.readChildrenFullySafe(Integer.MAX_VALUE);
        }
        super.appendChild(child);
    }

    public void insertChildAt(int pos, Object child) throws XmlPullParserException {
        if (this.pp != null && pos >= this.childrenCount) {
            this.readChildrenPartialSafe(pos);
        }
        super.insertChildAt(pos, child);
    }

    public void removeChildAt(int pos) throws XmlPullParserException {
        if (this.pp != null && pos >= this.childrenCount) {
            this.readChildrenFullySafe(pos);
        }
        super.removeChildAt(pos);
    }

    public void replaceChildAt(int pos, Object child) throws XmlPullParserException {
        if (this.pp != null && pos >= this.childrenCount) {
            this.readChildrenFullySafe(pos);
        }
        super.replaceChildAt(pos, child);
    }

    public void removeChildren() throws XmlPullParserException {
        if (this.pp != null) {
            try {
                this.skipChildren();
            }
            catch (IOException ex) {
                throw new PullParserRuntimeException("removeChildren(): could not skip children", ex);
            }
        }
        super.removeChildren();
    }

    protected void printFields(StringBuffer buf) {
        buf.append(" pp=" + this.pp);
        buf.append(" depth=" + this.depth);
        super.printFields(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PullNode={");
        this.printFields(buf);
        buf.append(" }");
        return buf.toString();
    }
}

