/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.CommandPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.TaskPoshiElement;
import com.liferay.poshi.core.elements.ThenPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.Dom4JUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ForPoshiElement
extends PoshiElement {
    protected String typeAttributeName;
    private static final String _ELEMENT_NAME = "for";
    private static final String _POSHI_SCRIPT_KEYWORD = "for";
    private static final Pattern _blockNamePattern = Pattern.compile("^for[\\s]*\\(.*?\\)$", 32);
    private static final Pattern _blockParameterPattern = Pattern.compile("var[\\s]*([\\w]*)[\\s]*:[\\s]*([\\w]*)[\\s]*(?:(\\$\\{.*}|.*))");

    public Element addAttribute(String name, String value) {
        if (name.equals("list") || name.equals("table")) {
            this.typeAttributeName = name;
        }
        return super.addAttribute(name, value);
    }

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType("for", element)) {
            return new ForPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ForPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public String getPoshiLogDescriptor() {
        return this.getBlockName(this.getPoshiScript());
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String value;
        String parentheticalContent = this.getParentheticalContent(this.getBlockName(poshiScript));
        Matcher matcher = _blockParameterPattern.matcher(parentheticalContent);
        if (matcher.find()) {
            int quoteCount;
            int escapedQuoteCount;
            this.addAttribute("param", matcher.group(1));
            value = matcher.group(3);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = this.getDoubleQuotedContent(value);
            }
            if (value.contains("\"") && (escapedQuoteCount = StringUtils.countMatches((String)value, (String)"\\\"")) != (quoteCount = StringUtils.countMatches((String)value, (String)"\""))) {
                throw new PoshiScriptParserException("Unescaped quotes in list value: " + value, poshiScript, (PoshiElement)this.getParent());
            }
        } else {
            throw new PoshiScriptParserException("Invalid parameter syntax: " + parentheticalContent, poshiScript, (PoshiElement)this.getParent());
        }
        this.addAttribute(matcher.group(2), value);
        String blockContent = this.getBlockContent(poshiScript);
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(blockContent)) {
            this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptSnippet));
        }
    }

    @Override
    public String toPoshiScript() {
        return "\n" + this.createPoshiScriptBlock(this.getPoshiNodes());
    }

    protected ForPoshiElement() {
        super("for");
    }

    protected ForPoshiElement(Element element) {
        super("for", element);
        this.initTypeAttributeName(element);
    }

    protected ForPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super("for", attributes, nodes);
    }

    protected ForPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super("for", parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        StringBuilder sb = new StringBuilder();
        sb.append("for (var ");
        sb.append(this.attributeValue("param"));
        sb.append(" : ");
        sb.append(this.typeAttributeName);
        sb.append(" ");
        String typeAttributeValue = this.attributeValue(this.typeAttributeName);
        if (this.isQuotedContent(typeAttributeValue)) {
            typeAttributeValue = "\"" + typeAttributeValue + "\"";
        }
        sb.append(typeAttributeValue);
        sb.append(")");
        return sb.toString();
    }

    protected void initTypeAttributeName(Element element) {
        if (element.attribute("list") != null) {
            this.typeAttributeName = "list";
            return;
        }
        if (element.attribute("table") != null) {
            this.typeAttributeName = "table";
            return;
        }
        try {
            throw new IllegalArgumentException("Invalid 'for' element " + Dom4JUtil.format(element));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Invalid 'for' element", ioException);
        }
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!(parentPoshiElement instanceof CommandPoshiElement || parentPoshiElement instanceof ForPoshiElement || parentPoshiElement instanceof TaskPoshiElement || parentPoshiElement instanceof ThenPoshiElement)) {
            return false;
        }
        return this.isValidPoshiScriptBlock(_blockNamePattern, poshiScript);
    }
}

