/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.UnsyncFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnsyncBufferedInputStream
extends UnsyncFilterInputStream {
    private static final int _DEFAULT_BUFFER_SIZE = 8192;
    private byte[] _buffer;
    private int _firstInvalidIndex;
    private int _index;
    private int _markLimitIndex = -1;

    public UnsyncBufferedInputStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public UnsyncBufferedInputStream(InputStream inputStream, int size) {
        super(inputStream);
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 1");
        }
        this._buffer = new byte[size];
    }

    @Override
    public int available() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        return this.inputStream.available() + (this._firstInvalidIndex - this._index);
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
            this._buffer = null;
        }
    }

    @Override
    public void mark(int readLimit) {
        if (readLimit <= 0) {
            return;
        }
        this._markLimitIndex = readLimit;
        if (this._index == 0) {
            return;
        }
        int available = this._firstInvalidIndex - this._index;
        if (available > 0) {
            System.arraycopy(this._buffer, this._index, this._buffer, 0, available);
            this._index = 0;
            this._firstInvalidIndex = available;
        } else {
            this._firstInvalidIndex = 0;
            this._index = 0;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this._index >= this._firstInvalidIndex) {
            this._fillInBuffer();
            if (this._index >= this._firstInvalidIndex) {
                return -1;
            }
        }
        return this._buffer[this._index++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int currentRead;
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("{length=" + length + "}");
        }
        if (length == 0) {
            return 0;
        }
        int read = 0;
        do {
            if ((currentRead = this._readOnce(bytes, offset + read, length - read)) > 0) continue;
            if (read != 0) break;
            read = currentRead;
            break;
        } while ((read += currentRead) < length && this.inputStream.available() > 0);
        return read;
    }

    @Override
    public void reset() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (this._markLimitIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this._index = 0;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Input stream is null");
        }
        if (skip <= 0L) {
            return 0L;
        }
        long available = this._firstInvalidIndex - this._index;
        if (available <= 0L) {
            if (this._markLimitIndex < 0) {
                return this.inputStream.skip(skip);
            }
            this._fillInBuffer();
            available = this._firstInvalidIndex - this._index;
            if (available <= 0L) {
                return 0L;
            }
        }
        if (available < skip) {
            skip = available;
        }
        this._index = (int)((long)this._index + skip);
        return skip;
    }

    private void _fillInBuffer() throws IOException {
        if (this._markLimitIndex < 0) {
            this._firstInvalidIndex = 0;
            this._index = 0;
            int number = this.inputStream.read(this._buffer);
            if (number > 0) {
                this._firstInvalidIndex = number;
            }
            return;
        }
        if (this._index >= this._markLimitIndex) {
            this._markLimitIndex = -1;
            this._firstInvalidIndex = 0;
            this._index = 0;
        } else if (this._index == this._buffer.length) {
            int newBufferSize = this._buffer.length * 2;
            if (newBufferSize > this._markLimitIndex) {
                newBufferSize = this._markLimitIndex;
            }
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._buffer.length);
            this._buffer = newBuffer;
        }
        this._firstInvalidIndex = this._index;
        int number = this.inputStream.read(this._buffer, this._index, this._buffer.length - this._index);
        if (number > 0) {
            this._firstInvalidIndex += number;
        }
    }

    private int _readOnce(byte[] bytes, int offset, int length) throws IOException {
        int available = this._firstInvalidIndex - this._index;
        if (available <= 0) {
            if (this._markLimitIndex < 0 && length >= this._buffer.length) {
                return this.inputStream.read(bytes, offset, length);
            }
            this._fillInBuffer();
            available = this._firstInvalidIndex - this._index;
            if (available <= 0) {
                return -1;
            }
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this._buffer, this._index, bytes, offset, length);
        this._index += length;
        return length;
    }
}

