/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.regex.Pattern;

@FileStatefulCheck
public class UnnecessaryParenthesesCheck
extends AbstractCheck {
    public static final String MSG_IDENT = "unnecessary.paren.ident";
    public static final String MSG_ASSIGN = "unnecessary.paren.assign";
    public static final String MSG_EXPR = "unnecessary.paren.expr";
    public static final String MSG_LITERAL = "unnecessary.paren.literal";
    public static final String MSG_STRING = "unnecessary.paren.string";
    public static final String MSG_RETURN = "unnecessary.paren.return";
    public static final String MSG_LAMBDA = "unnecessary.paren.lambda";
    private static final Pattern NEWLINE = Pattern.compile("\\R");
    private static final String QUOTE = "\"";
    private static final int MAX_QUOTED_LENGTH = 25;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133, 204};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private static final int[] CONDITIONALS_AND_RELATIONAL = new int[]{110, 111, 121, 118, 117, 120, 119, 116, 115};
    private static final int[] UNARY_AND_POSTFIX = new int[]{31, 32, 129, 130, 132, 131, 25, 26};
    private DetailAST parentToSkip;
    private int assignDepth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100, 181, 204, 111, 121, 118, 117, 120, 119, 116, 115, 31, 32, 129, 130, 132, 131, 25, 26};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100, 181, 204, 111, 121, 118, 117, 120, 119, 116, 115, 31, 32, 129, 130, 132, 131, 25, 26};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type == 181 && UnnecessaryParenthesesCheck.isLambdaSingleParameterSurrounded(ast)) {
            this.log(ast, MSG_LAMBDA, ast.getText());
        } else if (type != 80 || parent.getType() != 160) {
            boolean surrounded = UnnecessaryParenthesesCheck.isSurrounded(ast);
            if (surrounded && type == 58) {
                this.parentToSkip = ast.getParent();
                this.log(ast, MSG_IDENT, ast.getText());
            } else if (surrounded && TokenUtil.isOfType(type, LITERALS)) {
                this.parentToSkip = ast.getParent();
                if (type == 139) {
                    this.log(ast, MSG_STRING, UnnecessaryParenthesesCheck.chopString(ast.getText()));
                } else if (type == 204) {
                    String logString = QUOTE + NEWLINE.matcher(ast.getFirstChild().getText()).replaceAll("\\\\n") + QUOTE;
                    this.log(ast, MSG_STRING, UnnecessaryParenthesesCheck.chopString(logString));
                } else {
                    this.log(ast, MSG_LITERAL, ast.getText());
                }
            } else if (TokenUtil.isOfType(type, ASSIGNMENTS)) {
                ++this.assignDepth;
                DetailAST last = ast.getLastChild();
                if (last.getType() == 77) {
                    this.log(ast, MSG_ASSIGN, new Object[0]);
                }
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type != 80 || parent.getType() != 160) {
            if (type == 28) {
                this.checkExpression(ast);
            } else if (TokenUtil.isOfType(type, ASSIGNMENTS)) {
                --this.assignDepth;
            } else if (UnnecessaryParenthesesCheck.checkAroundOperators(ast)) {
                this.log(ast.getPreviousSibling(), MSG_EXPR, new Object[0]);
            }
        }
    }

    private static boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        return prev != null && prev.getType() == 76;
    }

    private static boolean isExprSurrounded(DetailAST ast) {
        return ast.getFirstChild().getType() == 76;
    }

    private void checkExpression(DetailAST ast) {
        if (this.parentToSkip != ast && UnnecessaryParenthesesCheck.isExprSurrounded(ast)) {
            if (this.assignDepth >= 1) {
                this.log(ast, MSG_ASSIGN, new Object[0]);
            } else if (ast.getParent().getType() == 88) {
                this.log(ast, MSG_RETURN, new Object[0]);
            } else {
                this.log(ast, MSG_EXPR, new Object[0]);
            }
        }
        this.parentToSkip = null;
    }

    private static boolean checkAroundOperators(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        boolean result = TokenUtil.isOfType(type, CONDITIONALS_AND_RELATIONAL) && TokenUtil.isOfType(parent.getType(), 116, 115) && UnnecessaryParenthesesCheck.isSurrounded(ast) ? false : (TokenUtil.isOfType(type, CONDITIONALS_AND_RELATIONAL) || TokenUtil.isOfType(type, UNARY_AND_POSTFIX)) && TokenUtil.isOfType(parent.getType(), CONDITIONALS_AND_RELATIONAL) && UnnecessaryParenthesesCheck.isSurrounded(ast);
        return result;
    }

    private static boolean isLambdaSingleParameterSurrounded(DetailAST ast) {
        DetailAST parameters;
        DetailAST firstChild = ast.getFirstChild();
        boolean result = false;
        if (firstChild != null && firstChild.getType() == 76 && (parameters = firstChild.getNextSibling()).getChildCount(21) == 1 && !parameters.getFirstChild().findFirstToken(13).hasChildren()) {
            result = true;
        }
        return result;
    }

    private static String chopString(String value) {
        String result = value;
        if (value.length() > 25) {
            result = value.substring(0, 25) + "...\"";
        }
        return result;
    }
}

