/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeVelocityMigrationCheck;
import com.liferay.source.formatter.check.util.SourceUtil;

public class UpgradeVelocityLiferayTaglibReferenceMigrationCheck
extends BaseUpgradeVelocityMigrationCheck {
    private static final String _FREEMARKER_LIFERAY_BREADCRUMBS = "<@liferay.breadcrumbs />";
    private static final String _FREEMARKER_LIFERAY_LANGUAGE_FORMAT = "<@liferay.language_format arguments=\"${site_name}\" key=\"go-to-x\" />";
    private static final String _FREEMARKER_LIFERAY_LANGUAGE_KEY = "<@liferay.language key=";
    private static final String _FREEMARKER_LIFERAY_THEME_INCLUDE = "<@liferay_util[\"include\"] page=";
    private static final String _FREEMARKER_LIFERAY_THEME_WRAP = "<@liferay_theme[\"wrap-portlet\"] page=";
    private static final String _VELOCITY_LIFERAY_BREADCRUMBS = "#breadcrumbs";
    private static final String _VELOCITY_LIFERAY_LANGUAGE = "#language";
    private static final String _VELOCITY_LIFERAY_LANGUAGE_FORMAT = "#language_format";
    private static final String _VELOCITY_LIFERAY_LANGUAGE_FORMAT_ARGUMENTS = "(\"go-to-x\", [$site_name])";
    private static final String _VELOCITY_LIFERAY_THEME_INCLUDE = "$theme.include";
    private static final String _VELOCITY_LIFERAY_THEME_WRAP = "$theme.wrapPortlet";

    @Override
    protected String migrateContent(String content) {
        String[] lines = StringUtil.splitLines(content);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.contains(_VELOCITY_LIFERAY_BREADCRUMBS)) {
                lines[i] = this._migrateVelocityLiferayBreadCrumbs(line);
                continue;
            }
            if (line.contains(_VELOCITY_LIFERAY_LANGUAGE)) {
                if (line.contains(_VELOCITY_LIFERAY_LANGUAGE_FORMAT)) {
                    lines[i] = this._migrateVelocityLanguageFormat(line);
                    continue;
                }
                lines[i] = this._migrateVelocityLanguage(line);
                continue;
            }
            if (line.contains(_VELOCITY_LIFERAY_THEME_INCLUDE)) {
                lines[i] = this._migrateVelocityLiferayThemeInclude(line);
                continue;
            }
            if (!line.contains(_VELOCITY_LIFERAY_THEME_WRAP)) continue;
            lines[i] = this._migrateVelocityLiferayThemeWrap(line);
        }
        return com.liferay.petra.string.StringUtil.merge(lines, "\n");
    }

    private String _migrateVelocityLanguage(String line) {
        String newLine = this._replaceLine(line, _VELOCITY_LIFERAY_LANGUAGE, "(", _FREEMARKER_LIFERAY_LANGUAGE_KEY);
        int languageKeyIndex = newLine.indexOf(_FREEMARKER_LIFERAY_LANGUAGE_KEY);
        String endLine = newLine.substring(languageKeyIndex);
        String newEndLine = StringUtil.replaceFirst(endLine, ')', " />");
        return StringUtil.replace(newLine, endLine, newEndLine);
    }

    private String _migrateVelocityLanguageFormat(String line) {
        return this._replaceLine(line, _VELOCITY_LIFERAY_LANGUAGE_FORMAT, _VELOCITY_LIFERAY_LANGUAGE_FORMAT_ARGUMENTS, _FREEMARKER_LIFERAY_LANGUAGE_FORMAT);
    }

    private String _migrateVelocityLiferayBreadCrumbs(String line) {
        return this._replaceLine(line, _VELOCITY_LIFERAY_BREADCRUMBS, "()", _FREEMARKER_LIFERAY_BREADCRUMBS);
    }

    private String _migrateVelocityLiferayThemeInclude(String line) {
        String newLine = this._replaceLine(line, _VELOCITY_LIFERAY_THEME_INCLUDE, "($", _FREEMARKER_LIFERAY_THEME_INCLUDE);
        return StringUtil.replaceLast(newLine, ')', " />");
    }

    private String _migrateVelocityLiferayThemeWrap(String line) {
        String newLine = this._replaceLine(line, _VELOCITY_LIFERAY_THEME_WRAP, "(", _FREEMARKER_LIFERAY_THEME_WRAP);
        int newStartIndex = newLine.indexOf(_FREEMARKER_LIFERAY_THEME_WRAP);
        String indent = SourceUtil.getIndent(newLine);
        newLine = StringUtil.replace(newLine, ".vm", ".ftl");
        newLine = StringUtil.replaceFirst(newLine, ")", StringBundler.concat(" ", "/>", "\n", indent, "</@>"), newStartIndex);
        newLine = StringUtil.replaceFirst(newLine, ",", StringBundler.concat(">\n", indent, "\t", _FREEMARKER_LIFERAY_THEME_INCLUDE), newStartIndex);
        return this._replaceLine(newLine, "=", "$", "=");
    }

    private String _replaceLine(String line, String oldSub1, String oldSub2, String newSub) {
        return StringUtil.replace(line, new String[]{oldSub1 + oldSub2, oldSub1 + ' ' + oldSub2}, new String[]{newSub, newSub});
    }
}

