/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesPlaywrightTestCheck
extends BaseFileCheck {
    private static final String _RELEVANT_RULE_NAMES = "relevant.rule.names";
    private static final String _TESTRAY_MAIN_COMPONENT_NAME = "testray.main.component.name";
    private List<String> _buildGradleFileNames;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/test.properties")) {
            return content;
        }
        if (absolutePath.contains("/modules/test/playwright/tests/")) {
            int x;
            this._checkMissingConfigTs(fileName, absolutePath);
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            String testrayMainComponentName = properties.getProperty(_TESTRAY_MAIN_COMPONENT_NAME);
            if (testrayMainComponentName == null) {
                this.addMessage(fileName, "Missing property \"testray.main.component.name\" in test.properties");
                return content;
            }
            List<String> buildGradleFileNames = this._getBuildGradleFileNames();
            if (ListUtil.isEmpty(buildGradleFileNames)) {
                return content;
            }
            String moduleName = this._getModuleName(absolutePath, 2);
            List<Object> testPropertiesFileNames = new ArrayList();
            for (String buildGradleFileName : buildGradleFileNames) {
                if (!buildGradleFileName.endsWith("/" + moduleName + "/build.gradle")) continue;
                x = buildGradleFileName.lastIndexOf("/");
                testPropertiesFileNames.add(buildGradleFileName.substring(0, x) + "/test.properties");
            }
            if (ListUtil.isEmpty(testPropertiesFileNames = ListUtil.filter(testPropertiesFileNames, testPropertiesFileName -> !testPropertiesFileName.endsWith("/modules/apps/" + moduleName + "/test.properties") && !testPropertiesFileName.endsWith("/modules/dxp/apps/" + moduleName + "/test.properties"))) || testPropertiesFileNames.size() != 1) {
                return content;
            }
            String testPropertiesFileName2 = (String)testPropertiesFileNames.get(0);
            File file = new File(testPropertiesFileName2);
            if (!file.exists()) {
                x = testPropertiesFileName2.indexOf("/modules/");
                int y = testPropertiesFileName2.lastIndexOf("/");
                this.addMessage(fileName, "Missing test.properties in " + testPropertiesFileName2.substring(x + 1, y));
                return content;
            }
            this._checkMissingPlaywrightTestProjectProperty(fileName, FileUtil.read(file), moduleName, file.getAbsolutePath());
        }
        if (absolutePath.contains("/modules/apps/") || absolutePath.contains("/modules/dxp/apps/")) {
            String moduleName = this._getModuleName(absolutePath, 1);
            if (absolutePath.endsWith("/modules/apps/" + moduleName + "/test.properties") || absolutePath.endsWith("/modules/dxp/apps/" + moduleName + "/test.properties")) {
                return content;
            }
            File file = new File(StringBundler.concat(this.getPortalDir(), "/modules/test/playwright/tests/", moduleName, "/main"));
            if (!file.exists()) {
                return content;
            }
            if (!(file = new File(file, "test.properties")).exists()) {
                this.addMessage(fileName, "Missing test.properties in playwright/tests/" + moduleName + "/main");
                return content;
            }
            this._checkMissingPlaywrightTestProjectProperty(fileName, content, moduleName, null);
        }
        return content;
    }

    private void _checkMissingConfigTs(String fileName, String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        String playwrightTestDirLocation = absolutePath.substring(0, x);
        File file = new File(playwrightTestDirLocation + "/config.ts");
        if (!file.exists()) {
            this.addMessage(fileName, "Missing config.ts in " + playwrightTestDirLocation);
        }
    }

    private void _checkMissingPlaywrightTestProjectProperty(String fileName, String content, String moduleName, String moduleTestPropertiesFilePath) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        List<String> relevantRuleNames = ListUtil.fromString(properties.getProperty(_RELEVANT_RULE_NAMES), ",");
        if (ListUtil.isEmpty(relevantRuleNames)) {
            this.addMessage(fileName, "Missing property \"relevant.rule.names\" in test.properties for Playwright tests");
            return;
        }
        for (String relevantRuleName : relevantRuleNames) {
            String testBatchNamesRelevantName;
            String playwrightRuleName;
            if (!relevantRuleName.endsWith("-playwright-rule") || Validator.isBlank(playwrightRuleName = properties.getProperty(testBatchNamesRelevantName = "test.batch.names[relevant][" + relevantRuleName + "]"))) continue;
            String playwrightProjectsIncludesPropertyName = StringBundler.concat("playwright.projects.includes[", playwrightRuleName, "][relevant][", relevantRuleName, "]");
            List<String> playwrightProjectsIncludesList = ListUtil.fromString(properties.getProperty(playwrightProjectsIncludesPropertyName), ",");
            String additionalMessage = "";
            if (moduleTestPropertiesFilePath != null) {
                int x = moduleTestPropertiesFilePath.indexOf("/modules/");
                additionalMessage = " in " + moduleTestPropertiesFilePath.substring(x + 1);
            }
            if (ListUtil.isEmpty(playwrightProjectsIncludesList)) {
                this.addMessage(fileName, StringBundler.concat("Missing property \"", playwrightProjectsIncludesPropertyName, "\"", additionalMessage));
                continue;
            }
            if (playwrightProjectsIncludesList.contains(moduleName + ".main")) continue;
            this.addMessage(fileName, StringBundler.concat("Missing property value \"", moduleName, ".main", "\" in \"", playwrightProjectsIncludesPropertyName, "\"", additionalMessage));
        }
    }

    private synchronized List<String> _getBuildGradleFileNames() throws IOException {
        if (this._buildGradleFileNames != null) {
            return this._buildGradleFileNames;
        }
        this._buildGradleFileNames = SourceFormatterUtil.scanForFileNames(this.getPortalDir().getCanonicalPath() + "/modules", new String[]{"apps/**/build.gradle", "dxp/apps/**/build.gradle"});
        return this._buildGradleFileNames;
    }

    private String _getModuleName(String absolutePath, int depth) {
        int i = 1;
        int x = absolutePath.lastIndexOf("/");
        String s = absolutePath.substring(0, x);
        while (true) {
            x = s.lastIndexOf("/");
            if (i == depth) {
                return s.substring(x + 1);
            }
            ++i;
            s = s.substring(0, x);
        }
    }
}

