/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security;

import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SecureRandomUtil {
    private static final int _BUFFER_SIZE;
    private static final byte[] _BYTES;
    private static final int _MIN_BUFFER_SIZE = 1024;
    private static final Random _gapRandom;
    private static final AtomicInteger _index;
    private static final Random _random;
    private static final AtomicBoolean _reloadingFlag;

    public static boolean nextBoolean() {
        byte b = SecureRandomUtil.nextByte();
        return b >= 0;
    }

    public static byte nextByte() {
        int index = _index.getAndIncrement();
        if (index < _BUFFER_SIZE) {
            return _BYTES[index];
        }
        return (byte)SecureRandomUtil._reload(index);
    }

    public static double nextDouble() {
        int index = _index.getAndAdd(8);
        if (index + 7 < _BUFFER_SIZE) {
            return BigEndianCodec.getDouble(_BYTES, index);
        }
        return Double.longBitsToDouble(SecureRandomUtil._reload(index));
    }

    public static float nextFloat() {
        int index = _index.getAndAdd(4);
        if (index + 3 < _BUFFER_SIZE) {
            return BigEndianCodec.getFloat(_BYTES, index);
        }
        return Float.intBitsToFloat((int)SecureRandomUtil._reload(index));
    }

    public static int nextInt() {
        int index = _index.getAndAdd(4);
        if (index + 3 < _BUFFER_SIZE) {
            return BigEndianCodec.getInt(_BYTES, index);
        }
        return (int)SecureRandomUtil._reload(index);
    }

    public static long nextLong() {
        int index = _index.getAndAdd(8);
        if (index + 7 < _BUFFER_SIZE) {
            return BigEndianCodec.getLong(_BYTES, index);
        }
        return SecureRandomUtil._reload(index);
    }

    private static long _reload(int index) {
        if (_reloadingFlag.compareAndSet(false, true)) {
            _random.nextBytes(_BYTES);
            _gapRandom.setSeed(_random.nextLong());
            _index.set(0);
            _reloadingFlag.set(false);
        }
        return _gapRandom.nextLong() ^ BigEndianCodec.getLong(_BYTES, Math.abs(index % (_BUFFER_SIZE - 7)));
    }

    static {
        _gapRandom = new Random();
        _index = new AtomicInteger();
        _random = new SecureRandom();
        _reloadingFlag = new AtomicBoolean();
        int bufferSize = GetterUtil.getInteger(SystemProperties.get(SecureRandomUtil.class.getName() + ".buffer.size"));
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        _BUFFER_SIZE = bufferSize;
        _BYTES = new byte[_BUFFER_SIZE];
        _random.nextBytes(_BYTES);
        _gapRandom.setSeed(_random.nextLong());
    }
}

