/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.parser.JavaClassType;
import com.liferay.source.formatter.parser.JavaParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JavaSignature {
    private final List<JavaParameter> _parameters = new ArrayList<JavaParameter>();
    private JavaClassType _returnType;

    public void addParameter(String parameterName, String parameterType, Set<String> parameterAnnotations, boolean isFinal, String packageName, List<String> importNames) {
        this._parameters.add(new JavaParameter(parameterName, new JavaClassType(parameterType, packageName, importNames), parameterAnnotations, isFinal));
    }

    public List<JavaParameter> getParameters() {
        return this._parameters;
    }

    public String getReturnType() {
        return this.getReturnType(false);
    }

    public String getReturnType(boolean fullyQualifiedName) {
        if (this._returnType != null) {
            return this._returnType.toString(fullyQualifiedName);
        }
        return "";
    }

    public void setReturnType(String returnTypeString, String packageName, List<String> importNames) {
        if (Validator.isNotNull(returnTypeString)) {
            this._returnType = new JavaClassType(returnTypeString, packageName, importNames);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fullyQualifiedName) {
        StringBundler sb = new StringBundler(this._parameters.size() * 2 + 1);
        sb.append('(');
        for (JavaParameter parameter : this._parameters) {
            sb.append(parameter.getParameterType(fullyQualifiedName));
            sb.append(',');
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(')');
        return sb.toString();
    }
}

