/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseSourceCheck;
import com.liferay.source.formatter.check.FileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

public abstract class BaseFileCheck
extends BaseSourceCheck
implements FileCheck {
    private static final String _RELEASE_PROPERTIES_FILE_NAME = "release.properties";
    private static final Pattern _privateBranchNamePattern = Pattern.compile("private.branch.name=(.*)\n");
    private String _privatePortalVersion;
    private String _publicPortalVersion;

    @Override
    public String process(SourceProcessor sourceProcessor, String fileName, String absolutePath, String content) throws Exception {
        this.clearSourceFormatterMessages(fileName);
        this.setSourceProcessor(sourceProcessor);
        return this.doProcess(fileName, absolutePath, content);
    }

    protected void checkElementOrder(String fileName, Element rootElement, String elementName, String parentElementName, ElementComparator elementComparator) {
        if (rootElement == null) {
            return;
        }
        Node previousNode = null;
        Iterator iterator = rootElement.nodeIterator();
        while (iterator.hasNext()) {
            Text text;
            Node curNode = (Node)iterator.next();
            if (curNode instanceof Text && !StringUtil.startsWith(StringUtil.trim((text = (Text)curNode).asXML()), '#')) continue;
            if (previousNode == null) {
                previousNode = curNode;
                continue;
            }
            if (curNode instanceof Element && previousNode instanceof Element) {
                Element curElement = (Element)curNode;
                Element previousElement = (Element)previousNode;
                String curElementName = curElement.getName();
                String previousElementName = previousElement.getName();
                if (curElementName.equals(elementName) && previousElementName.equals(elementName) && elementComparator.compare(previousElement, curElement) > 0) {
                    StringBundler sb = new StringBundler(9);
                    sb.append("Incorrect order \"");
                    if (Validator.isNotNull(parentElementName)) {
                        sb.append(parentElementName);
                        sb.append("#");
                    }
                    sb.append(elementName);
                    sb.append("\": \"");
                    sb.append(elementComparator.getElementName(previousElement));
                    sb.append("\" should come after \"");
                    sb.append(elementComparator.getElementName(curElement));
                    sb.append("\"");
                    this.addMessage(fileName, sb.toString());
                }
            }
            previousNode = curNode;
        }
    }

    protected abstract String doProcess(String var1, String var2, String var3) throws Exception;

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected String getPortalVersion(boolean privateApp) throws IOException {
        String portalVersion = this._getPublicPortalVersion();
        if (privateApp) {
            portalVersion = this._getPrivatePortalVersion();
        }
        if (Validator.isNull(portalVersion) || privateApp) {
            return portalVersion;
        }
        return portalVersion;
    }

    private synchronized String _getPrivatePortalVersion() throws IOException {
        if (this._privatePortalVersion != null) {
            return this._privatePortalVersion;
        }
        this._privatePortalVersion = "";
        if (!this.isPortalSource()) {
            return this._privatePortalVersion;
        }
        File workingDirPropertiesFile = new File(this.getPortalDir(), "working.dir.properties");
        if (!workingDirPropertiesFile.exists()) {
            return this._privatePortalVersion;
        }
        String content = FileUtil.read(workingDirPropertiesFile);
        Matcher matcher = _privateBranchNamePattern.matcher(content);
        if (!matcher.find()) {
            return this._privatePortalVersion;
        }
        String privateBranchName = StringUtil.trim(matcher.group(1));
        if (Validator.isNull(privateBranchName)) {
            return this._privatePortalVersion;
        }
        String s = Pattern.quote("lp.version[" + privateBranchName + "]=");
        Pattern pattern = Pattern.compile(s + "(.*)");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return this._privatePortalVersion;
        }
        this._privatePortalVersion = StringUtil.trim(matcher.group(1));
        return this._privatePortalVersion;
    }

    private synchronized String _getPublicPortalVersion() throws IOException {
        if (this._publicPortalVersion != null) {
            return this._publicPortalVersion;
        }
        this._publicPortalVersion = "";
        if (!this.isPortalSource()) {
            return this._publicPortalVersion;
        }
        File workingDirPropertiesFile = new File(this.getPortalDir(), "working.dir.properties");
        if (workingDirPropertiesFile.exists()) {
            String privateBranchName;
            String content = FileUtil.read(workingDirPropertiesFile);
            Matcher matcher = _privateBranchNamePattern.matcher(content);
            if (matcher.find() && Validator.isNotNull(privateBranchName = StringUtil.trim(matcher.group(1))) && privateBranchName.endsWith("-private")) {
                String branchName = StringUtil.replaceLast(privateBranchName, "-private", "");
                String s = Pattern.quote("lp.version[" + branchName + "]=");
                Pattern pattern = Pattern.compile(s + "(.*)");
                matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String match = matcher.group(1);
                    this._publicPortalVersion = StringUtil.trim(match);
                }
            }
        } else {
            File releasePropertiesFile = new File(this.getPortalDir(), _RELEASE_PROPERTIES_FILE_NAME);
            if (releasePropertiesFile.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(releasePropertiesFile));
                String releaseInfoVersionMajor = properties.getProperty("release.info.version.major");
                String releaseInfoVersionMinor = properties.getProperty("release.info.version.minor");
                if (Validator.isNotNull(releaseInfoVersionMajor) && Validator.isNotNull(releaseInfoVersionMinor)) {
                    this._publicPortalVersion = StringBundler.concat(releaseInfoVersionMajor, ".", releaseInfoVersionMinor, ".0");
                }
            }
        }
        return this._publicPortalVersion;
    }
}

