/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.pql.PQLEntity;
import com.liferay.poshi.core.pql.PQLEntityFactory;
import com.liferay.poshi.core.pql.PQLModifier;
import com.liferay.poshi.core.pql.PQLOperator;
import com.liferay.poshi.core.pql.PQLOperatorFactory;
import com.liferay.poshi.core.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PQLQuery
extends PQLEntity {
    private final PQLEntity _pqlEntity1;
    private final PQLEntity _pqlEntity2;
    private final PQLOperator _pqlOperator;

    public static boolean isQuery(String pql) {
        if (pql == null) {
            return false;
        }
        String[] queryTokens = PQLQuery._getQueryTokens(pql = PQLQuery.removeModifierFromPQL(pql));
        return queryTokens != null;
    }

    public PQLQuery(String query) throws Exception {
        super(query);
        this._validateQuery(query);
        String[] queryTokens = PQLQuery._getQueryTokens(this.getPQL());
        this._pqlEntity1 = PQLEntityFactory.newPQLEntity(queryTokens[0]);
        this._pqlOperator = PQLOperatorFactory.newPQLOperator(queryTokens[1]);
        this._pqlEntity2 = PQLEntityFactory.newPQLEntity(queryTokens[2]);
    }

    @Override
    public Object getPQLResult(Properties properties) throws Exception {
        Object pqlResultObject = this._pqlOperator.getPQLResult(this._pqlEntity1, this._pqlEntity2, properties);
        if (!(pqlResultObject instanceof Boolean)) {
            throw new Exception("Unable to evaluate " + this.getPQL());
        }
        PQLModifier pqlModifier = this.getPQLModifier();
        if (pqlModifier != null) {
            pqlResultObject = pqlModifier.getPQLResult(pqlResultObject);
        }
        return pqlResultObject;
    }

    private static List<String> _getAllTokens(String query) {
        ArrayList<String> tokens = new ArrayList<String>();
        query = PQLQuery.fixPQL(query);
        while (true) {
            if (query.startsWith("(") && query.contains(")")) {
                int parenthesisCount = 0;
                for (int i = 0; i < query.length(); ++i) {
                    char c = query.charAt(i);
                    if (c == '(') {
                        ++parenthesisCount;
                    }
                    if (c == ')') {
                        --parenthesisCount;
                    }
                    if (parenthesisCount < 0) {
                        return null;
                    }
                    if (parenthesisCount != 0) continue;
                    int x = i + 1;
                    String token = query.substring(0, x);
                    tokens.add(token.trim());
                    query = query.substring(x);
                    query = query.trim();
                    break;
                }
                if (parenthesisCount <= 0) continue;
                return null;
            }
            if (PQLQuery._startsWithReservedToken(query)) {
                String reservedToken = PQLQuery._getStartingReservedToken(query);
                tokens.add(reservedToken);
                query = query.substring(reservedToken.length());
                query = query.trim();
                continue;
            }
            if (query.startsWith("\"") || query.startsWith("'")) {
                int quotationTokenEndIndex = PQLQuery._getQuotationTokenEndIndex(query);
                if (quotationTokenEndIndex == -1) {
                    return null;
                }
                String token = query.substring(0, quotationTokenEndIndex);
                tokens.add(token.trim());
                query = query.substring(quotationTokenEndIndex);
                query = query.trim();
                continue;
            }
            if (!query.contains(" ")) break;
            int x = query.indexOf(" ");
            String token = query.substring(0, x);
            tokens.add(token.trim());
            query = query.substring(x);
            query = query.trim();
        }
        tokens.add(query.trim());
        return tokens;
    }

    private static String[] _getQueryTokens(String query) {
        List<String> tokens = PQLQuery._getAllTokens(query);
        if (tokens == null) {
            return null;
        }
        List<List<String>> prioritizedOperatorList = PQLOperator.getPrioritizedOperatorList();
        int operatorIndex = -1;
        for (int i = prioritizedOperatorList.size() - 1; i >= 0; --i) {
            List<String> operators = prioritizedOperatorList.get(i);
            for (int j = 0; j < tokens.size(); ++j) {
                String token = tokens.get(j);
                if (!operators.contains(token)) continue;
                operatorIndex = j;
                break;
            }
            if (operatorIndex != -1) break;
        }
        if (operatorIndex != -1) {
            String entity1 = ListUtil.toString(tokens.subList(0, operatorIndex), " ");
            String operator = tokens.get(operatorIndex);
            String entity2 = ListUtil.toString(tokens.subList(operatorIndex + 1, tokens.size()), " ");
            if (entity1.equals("") || entity2.equals("")) {
                return null;
            }
            return new String[]{entity1, operator, entity2};
        }
        return null;
    }

    private static int _getQuotationTokenEndIndex(String query) {
        boolean escapeNextChar = false;
        char quotation = query.charAt(0);
        for (int i = 1; i < query.length(); ++i) {
            if (escapeNextChar) {
                escapeNextChar = false;
                continue;
            }
            char c = query.charAt(i);
            if (c == '\\') {
                escapeNextChar = true;
                continue;
            }
            if (c != quotation) continue;
            return i + 1;
        }
        return -1;
    }

    private static String _getStartingReservedToken(String query) {
        ArrayList<String> reservedTokens = new ArrayList<String>();
        reservedTokens.addAll(PQLOperator.getAvailableOperators());
        for (String reservedToken : reservedTokens) {
            if (!query.equals(reservedToken) && !query.startsWith(reservedToken + " ")) continue;
            return reservedToken;
        }
        return null;
    }

    private static boolean _startsWithReservedToken(String query) {
        String startingReservedToken = PQLQuery._getStartingReservedToken(query);
        return startingReservedToken != null;
    }

    private void _validateQuery(String query) throws Exception {
        if (!PQLQuery.isQuery(query)) {
            throw new Exception("Invalid query: " + query);
        }
    }
}

