/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDLineBreaksCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        return this._formatLineBreaks(shortFileName, content);
    }

    private String _formatLineBreaks(String content, Map<String, String> definitionsKeysMap) {
        if (definitionsKeysMap == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : definitionsKeysMap.entrySet()) {
            String definitionKey = entry.getValue();
            Pattern pattern = Pattern.compile(" " + definitionKey + ":");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return StringUtil.replaceFirst(content, " ", "\n", matcher.start());
        }
        return content;
    }

    private String _formatLineBreaks(String shortFileName, String content) {
        content = this._formatLineBreaks(content, BNDSourceUtil.getDefinitionKeysMap());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = BNDSourceUtil.getFileSpecificDefinitionKeysMap();
        return this._formatLineBreaks(content, fileSpecificDefinitionKeysMap.get(shortFileName));
    }
}

