/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@StatelessCheck
public class IllegalImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.illegal";
    private final List<Pattern> illegalPkgsRegexps = new ArrayList<Pattern>();
    private final List<Pattern> illegalClassesRegexps = new ArrayList<Pattern>();
    private String[] illegalPkgs;
    private String[] illegalClasses;
    private boolean regexp;

    public IllegalImportCheck() {
        this.setIllegalPkgs("sun");
    }

    public final void setIllegalPkgs(String ... from) {
        this.illegalPkgs = (String[])from.clone();
        this.illegalPkgsRegexps.clear();
        for (String illegalPkg : this.illegalPkgs) {
            this.illegalPkgsRegexps.add(CommonUtil.createPattern("^" + illegalPkg + "\\..*"));
        }
    }

    public void setIllegalClasses(String ... from) {
        for (String illegalClass : this.illegalClasses = (String[])from.clone()) {
            this.illegalClassesRegexps.add(CommonUtil.createPattern(illegalClass));
        }
    }

    public void setRegexp(boolean regexp) {
        this.regexp = regexp;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (this.isIllegalImport(imp.getText())) {
            this.log(ast, MSG_KEY, imp.getText());
        }
    }

    private boolean isIllegalImportByRegularExpressions(String importText) {
        boolean result = false;
        for (Pattern pattern : this.illegalPkgsRegexps) {
            if (!pattern.matcher(importText).matches()) continue;
            result = true;
            break;
        }
        for (Pattern pattern : this.illegalClassesRegexps) {
            if (!pattern.matcher(importText).matches()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isIllegalImportByPackagesAndClassNames(String importText) {
        boolean result = false;
        for (String element : this.illegalPkgs) {
            if (!importText.startsWith(element + ".")) continue;
            result = true;
            break;
        }
        if (this.illegalClasses != null) {
            for (String element : this.illegalClasses) {
                if (!importText.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isIllegalImport(String importText) {
        boolean result = this.regexp ? this.isIllegalImportByRegularExpressions(importText) : this.isIllegalImportByPackagesAndClassNames(importText);
        return result;
    }
}

