/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseChainedMethodCheck;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JSONUtilCheck
extends BaseChainedMethodCheck {
    private static final String _MSG_USE_JSON_UTIL_PUT = "json.util.put.use";
    private static final String _MSG_USE_JSON_UTIL_PUT_ALL = "json.util.put.all.use";
    private static final String _MSG_USE_JSON_UTIL_TO_STRING_1 = "json.util.to.string.use.1";
    private static final String _MSG_USE_JSON_UTIL_TO_STRING_2 = "json.util.to.string.use.2";
    private static final String[] _VARIABLE_TYPE_NAMES = new String[]{"JSONArray", "JSONObject"};

    public int[] getDefaultTokens() {
        return new int[]{80, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkChainedPutCalls(detailAST);
            this._checkStringValueOfCalls(detailAST);
            this._checkToJSONStringCalls(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        DetailAST methodCallDetailAST = this._getMethodCallDetailAST(detailAST, parentDetailAST);
        if (methodCallDetailAST == null) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() > 0) {
            return;
        }
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        FullIdent fullIdent1 = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        String methodName = fullIdent1.getText();
        if (!methodName.equals("JSONFactoryUtil.createJSONArray") && !methodName.equals("JSONFactoryUtil.createJSONObject")) {
            return;
        }
        String variableName = this.getVariableName(detailAST, parentDetailAST);
        if (variableName == null) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            FullIdent fullIdent2 = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, "put");
            if (fullIdent2 == null) continue;
            this.log(detailAST, _MSG_USE_JSON_UTIL_PUT, new Object[]{methodName, fullIdent1.getLineNo(), variableName + ".put", fullIdent2.getLineNo(), "JSONUtil.put"});
        } while (!this.containsVariableName(nextSiblingDetailAST, variableName, true));
    }

    private void _checkChainedPutCalls(DetailAST methodCallDetailAST) {
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), "JSONUtil.put")) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() != 1) {
            return;
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return;
        }
        DetailAST nextSiblingDetailAST = methodCallDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() == 58 && Objects.equals(nextSiblingDetailAST.getText(), "put")) {
            this.log(methodCallDetailAST, _MSG_USE_JSON_UTIL_PUT_ALL, new Object[0]);
        }
    }

    private void _checkStringValueOfCalls(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), "String.valueOf")) {
            return;
        }
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        if (elistDetailAST == null) {
            return;
        }
        firstChildDetailAST = elistDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 27) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(firstChildDetailAST, true, 27);
        if (methodCallDetailASTList.isEmpty()) {
            if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 59) {
                return;
            }
            fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            if (Objects.equals(fullIdent.getText(), "JSONUtil.put") || Objects.equals(fullIdent.getText(), "JSONUtil.putAll")) {
                this.log(detailAST, _MSG_USE_JSON_UTIL_TO_STRING_1, new Object[0]);
            }
            return;
        }
        List<Object> chainedMethodNames = new ArrayList();
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<DetailAST> childMethodCallDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST != null && !(childMethodCallDetailASTList = this.getAllChildTokens(dotDetailAST, false, 27)).isEmpty()) continue;
            BaseCheck.ChainInformation chainInformation = this.getChainInformation(methodCallDetailAST);
            chainedMethodNames = chainInformation.getMethodNames();
        }
        for (String chainedMethodName : chainedMethodNames) {
            if (chainedMethodName.equals("put") || chainedMethodName.equals("putAll")) continue;
            return;
        }
        DetailAST methodCallDetailAST = methodCallDetailASTList.get(methodCallDetailASTList.size() - 1);
        firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        String methodCall = fullIdent.getText();
        if (methodCall.startsWith("JSONUtil.")) {
            this.log(detailAST, _MSG_USE_JSON_UTIL_TO_STRING_1, new Object[0]);
        }
    }

    private void _checkToJSONStringCalls(DetailAST detailAST) {
        if (!StringUtil.equals("toJSONString", this.getMethodName(detailAST))) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        if (methodCallDetailASTList.size() == 1) {
            DetailAST methodCallDetailAST = methodCallDetailASTList.get(0);
            DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
            if (firstChildDetailAST != null && firstChildDetailAST.getType() == 58 && this._isJSONTypeMethodCall(detailAST, this.getMethodName(methodCallDetailAST))) {
                this.log(detailAST, _MSG_USE_JSON_UTIL_TO_STRING_2, new Object[0]);
            }
            return;
        }
        if (ArrayUtil.contains(_VARIABLE_TYPE_NAMES, this.getVariableTypeName(detailAST, this.getVariableName(detailAST), false)) || this._isJSONUtilCall(detailAST)) {
            this.log(detailAST, _MSG_USE_JSON_UTIL_TO_STRING_2, new Object[0]);
        }
    }

    private DetailAST _getMethodCallDetailAST(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST != null && assignValueDetailAST.getType() == 27) {
            return assignValueDetailAST;
        }
        return null;
    }

    private boolean _isJSONTypeMethodCall(DetailAST detailAST, String methodName) {
        if (Validator.isNull(methodName)) {
            return false;
        }
        DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, 6);
        List<DetailAST> childDetailASTList = this.getAllChildTokens(parentDetailAST, false, 9);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (!StringUtil.equals(this.getName(childDetailAST), methodName) || !ArrayUtil.contains(_VARIABLE_TYPE_NAMES, this.getTypeName(childDetailAST, false))) continue;
            return true;
        }
        return false;
    }

    private boolean _isJSONUtilCall(DetailAST detailAST) {
        FullIdent fullIdent;
        String methodCall;
        if (detailAST.getChildCount() == 0) {
            return false;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 59 && (methodCall = (fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST)).getText()).startsWith("JSONUtil.")) {
            return true;
        }
        return this._isJSONUtilCall(firstChildDetailAST);
    }
}

