/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLSpringExtenderServiceCheck
extends BaseFileCheck {
    private static final String _ALLOWED_SPRING_EXTENDER_SERVICE_DIR_NAMES_KEY = "allowedSpringExtenderServiceDirNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/")) {
            return content;
        }
        List<String> allowedSpringExtenderServiceDirNames = this.getAttributeValues(_ALLOWED_SPRING_EXTENDER_SERVICE_DIR_NAMES_KEY, absolutePath);
        for (String allowedSpringExtenderServiceDirName : allowedSpringExtenderServiceDirNames) {
            if (!absolutePath.contains(allowedSpringExtenderServiceDirName)) continue;
            return content;
        }
        int x = absolutePath.indexOf("/modules/apps/archived/");
        if (x != -1) {
            return content;
        }
        if (fileName.endsWith("-service/src/main/resources/META-INF/spring/module-spring.xml")) {
            this.addMessage(fileName, "Do not use Spring extender service as a dependency injection, use DS instead");
        } else if (fileName.endsWith("/service.xml")) {
            Document document = SourceUtil.readXML(content);
            if (document == null) {
                return content;
            }
            Element rootElement = document.getRootElement();
            String dependencyInjector = rootElement.attributeValue("dependency-injector");
            if (Validator.isNotNull(dependencyInjector) && dependencyInjector.equals("spring")) {
                this.addMessage(fileName, "Do not use Spring extender service as a dependency injection, use DS instead");
            }
        }
        return content;
    }
}

