/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.dom4j.Document;
import org.dom4j.Element;

public class SystemEventCheck
extends BaseCheck {
    private static final String _MSG_MISSING_SYSTEM_EVENT = "system.event.missing";
    private static final String _MSG_UNNEEDED_SYSTEM_EVENT_1 = "system.event.unneeded.1";
    private static final String _MSG_UNNEEDED_SYSTEM_EVENT_2 = "system.event.unneeded.2";
    private Element _entityElement;

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._entityElement = null;
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        if (detailAST.getType() == 14) {
            this._checkSystemEventConstants(detailAST);
        }
    }

    private void _checkSystemEventConstants(DetailAST detailAST) {
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String className = this.getName(detailAST);
        if (!className.endsWith("LocalServiceImpl")) {
            return;
        }
        String entityName = StringUtil.removeSubstring(className, "LocalServiceImpl");
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> methodDefDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        for (DetailAST methodDefDetailAST : methodDefDetailASTList) {
            Element entityElement;
            DetailAST modifiersDetailAST = methodDefDetailAST.findFirstToken(5);
            if (!modifiersDetailAST.branchContains(62) || AnnotationUtil.containsAnnotation((DetailAST)methodDefDetailAST, (String)"Deprecated")) continue;
            String methodName = this.getName(methodDefDetailAST);
            if (this._hasSystemDeleteEventAnnotation(methodDefDetailAST)) {
                if (!entityName.equals(this._getFirstParameterTypeName(methodDefDetailAST))) {
                    this.log(methodDefDetailAST, _MSG_UNNEEDED_SYSTEM_EVENT_1, new Object[]{methodName, entityName});
                }
                if ((entityElement = this._getEntityElement(entityName)) == null) {
                    return;
                }
                if (this._implementsClassedModel(entityElement)) continue;
                this.log(methodDefDetailAST, _MSG_UNNEEDED_SYSTEM_EVENT_2, new Object[]{methodName, entityName});
                continue;
            }
            if (!methodName.startsWith("delete") || !this._hasDeleteFromPersistence(methodDefDetailASTList, methodDefDetailAST, entityName, methodName) || !entityName.equals(this._getFirstParameterTypeName(methodDefDetailAST))) continue;
            entityElement = this._getEntityElement(entityName);
            if (entityElement == null) {
                return;
            }
            if (!this._implementsClassedModel(entityElement)) continue;
            this.log(methodDefDetailAST, _MSG_MISSING_SYSTEM_EVENT, new Object[]{methodName});
        }
    }

    private DetailAST _getCalledMethodDefDetailAST(DetailAST methodDefDetailAST, String methodName, List<DetailAST> methodDefDetailASTList) {
        DetailAST matchingMethodDefDetailAST = null;
        for (DetailAST curMethodDefDetailAST : methodDefDetailASTList) {
            DetailAST identDetailAST;
            if (methodDefDetailAST.getLineNo() == curMethodDefDetailAST.getLineNo() || !methodName.equals((identDetailAST = curMethodDefDetailAST.findFirstToken(58)).getText())) continue;
            DetailAST parametersDetailAST = curMethodDefDetailAST.findFirstToken(20);
            List<DetailAST> parameterDefDetailASTList = this.getAllChildTokens(parametersDetailAST, false, 21);
            if (parameterDefDetailASTList.size() != 1) continue;
            if (matchingMethodDefDetailAST == null) {
                matchingMethodDefDetailAST = curMethodDefDetailAST;
                continue;
            }
            return null;
        }
        return matchingMethodDefDetailAST;
    }

    private Element _getEntityElement(String entityName) {
        if (this._entityElement != null) {
            return this._entityElement;
        }
        String absolutePath = this.getAbsolutePath();
        File serviceXMLFile = null;
        int pos = absolutePath.length();
        do {
            if ((pos = absolutePath.lastIndexOf("/", pos - 1)) != -1) continue;
            return null;
        } while (!(serviceXMLFile = new File(absolutePath.substring(0, pos + 1) + "service.xml")).exists());
        Document document = SourceUtil.readXML(serviceXMLFile);
        if (document == null) {
            return null;
        }
        Element rootElement = document.getRootElement();
        for (Element entityElement : rootElement.elements("entity")) {
            if (!entityName.equals(entityElement.attributeValue("name"))) continue;
            this._entityElement = entityElement;
            return this._entityElement;
        }
        return null;
    }

    private String _getFirstParameterTypeName(DetailAST methodDefDetailAST) {
        DetailAST parametersDetailAST = methodDefDetailAST.findFirstToken(20);
        List<DetailAST> parameterDefDetailASTList = this.getAllChildTokens(parametersDetailAST, false, 21);
        if (parameterDefDetailASTList.isEmpty()) {
            return null;
        }
        DetailAST firstParameterDefDetailAST = parameterDefDetailASTList.get(0);
        DetailAST typeDetailAST = firstParameterDefDetailAST.findFirstToken(13);
        DetailAST firstChildDetailAST = typeDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            return firstChildDetailAST.getText();
        }
        return null;
    }

    private String _getPrimaryKeyType(Element entityElement) {
        for (Element columnElement : entityElement.elements("column")) {
            if (!GetterUtil.getBoolean(columnElement.attributeValue("primary"))) continue;
            return columnElement.attributeValue("type");
        }
        return null;
    }

    private boolean _hasColumn(Element entityElement, String name) {
        for (Element columnElement : entityElement.elements("column")) {
            if (!name.equals(columnElement.attributeValue("name"))) continue;
            return true;
        }
        return false;
    }

    private boolean _hasDeleteFromPersistence(List<DetailAST> methodDefDetailASTList, DetailAST methodDefDetailAST, String entityName, String methodName) {
        if (methodDefDetailAST == null) {
            return false;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(methodDefDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST calledMethodDefDetailAST;
            DetailAST elistDetailAST;
            List<DetailAST> exprDetailASTList;
            FullIdent fullIdent;
            String methodCall;
            DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
            if (!(firstChildDetailAST.getType() == 59 ? (methodCall = (fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST)).getText()).matches("(?i)" + entityName + "Persistence\\.remove.*") || methodCall.equals("super." + methodName) : firstChildDetailAST.getType() == 58 && methodName.equals(firstChildDetailAST.getText()) && (exprDetailASTList = this.getAllChildTokens(elistDetailAST = methodCallDetailAST.findFirstToken(34), false, 28)).size() == 1 && this._hasDeleteFromPersistence(methodDefDetailASTList, calledMethodDefDetailAST = this._getCalledMethodDefDetailAST(methodDefDetailAST, methodName, methodDefDetailASTList), methodName, entityName))) continue;
            return true;
        }
        return false;
    }

    private boolean _hasSystemDeleteEventAnnotation(DetailAST methodDefDetailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)methodDefDetailAST, (String)"SystemEvent");
        if (annotationDetailAST == null) {
            return false;
        }
        List<DetailAST> annotationMemberValuePairDetailASTList = this.getAllChildTokens(annotationDetailAST, false, 160);
        for (DetailAST annotationMemberValuePairDetailAST : annotationMemberValuePairDetailASTList) {
            DetailAST exprDetailAST;
            FullIdent fullIdent;
            DetailAST identDetailAST = annotationMemberValuePairDetailAST.findFirstToken(58);
            if (!Objects.equals(identDetailAST.getText(), "type") || !Objects.equals((fullIdent = FullIdent.createFullIdentBelow((DetailAST)(exprDetailAST = annotationMemberValuePairDetailAST.findFirstToken(28)))).getText(), "SystemEventConstants.TYPE_DELETE")) continue;
            return true;
        }
        return false;
    }

    private boolean _implementsClassedModel(Element entityElement) {
        String primaryKeyType = this._getPrimaryKeyType(entityElement);
        return !Validator.isNull(primaryKeyType) && primaryKeyType.equals("long") && this._hasColumn(entityElement, "companyId") && this._hasColumn(entityElement, "createDate") && this._hasColumn(entityElement, "modifiedDate") && this._hasColumn(entityElement, "userId") && this._hasColumn(entityElement, "userName");
    }
}

