/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.PropertyValueComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleStylingCheck
extends BaseFileCheck {
    private static final Pattern _fileNamespattern = Pattern.compile("(\n\t*fileNames .+){2,}");
    private static final Pattern _mapKeyPattern = Pattern.compile("(\".+?\") *: *(\".+?\")");
    private static final Pattern _multiLineStringsPattern = Pattern.compile("(\"\"\"|''')\\\\\n.*?\\1", 32);
    private static final Pattern _stylingPattern1 = Pattern.compile("(\\A|\n)(\\w+)\\.(\\w+ = \\w+)(\n|\\Z)");
    private static final Pattern _stylingPattern2 = Pattern.compile("(\\A|\n)(\t*\\w+)(?! = .) *=(?!~) *(.*?)(\n|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixMissingLineBreakAroundCurlyBraces(content);
        content = this._sortFileNames(content);
        content = this._sortMapKeys("transformKeys", content);
        content = this._stylingCheck(content, _stylingPattern1, "$1$2 {\n\t$3\n}$4");
        content = this._stylingCheck(content, _stylingPattern2, "$1$2 = $3$4");
        return content;
    }

    private String _fixMissingLineBreakAroundCurlyBraces(String content) {
        int openCurlyBracePosition = -1;
        block0: while ((openCurlyBracePosition = content.indexOf("{", openCurlyBracePosition + 1)) != -1) {
            char previousChar = content.charAt(openCurlyBracePosition - 1);
            if (previousChar == '$') continue;
            int[] multiLineStringsPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringsPattern);
            if (ToolsUtil.isInsideQuotes(content, openCurlyBracePosition) || SourceUtil.isInsideMultiLines(SourceUtil.getLineNumber(content, openCurlyBracePosition), multiLineStringsPositions) || this._isInRegexPattern(content, openCurlyBracePosition) || this._isInSingleLineComment(content, openCurlyBracePosition)) continue;
            int closeCurlyBracePosition = openCurlyBracePosition;
            while ((closeCurlyBracePosition = content.indexOf("}", closeCurlyBracePosition + 1)) != -1) {
                char nextChar;
                String curlyBraceContent;
                int level;
                if (ToolsUtil.isInsideQuotes(content, closeCurlyBracePosition) || SourceUtil.isInsideMultiLines(SourceUtil.getLineNumber(content, closeCurlyBracePosition), multiLineStringsPositions) || this._isInRegexPattern(content, closeCurlyBracePosition) || this._isInSingleLineComment(content, closeCurlyBracePosition) || (level = this.getLevel(curlyBraceContent = content.substring(openCurlyBracePosition, closeCurlyBracePosition + 1), "{", "}")) != 0) continue;
                if (closeCurlyBracePosition < content.length() - 1 && ((nextChar = content.charAt(closeCurlyBracePosition + 1)) == ')' || nextChar == '.')) continue block0;
                previousChar = content.charAt(closeCurlyBracePosition - 1);
                if (previousChar != '\n' && previousChar != '\t') {
                    return StringUtil.insert(content, "\n", closeCurlyBracePosition);
                }
                nextChar = content.charAt(openCurlyBracePosition + 1);
                if (nextChar == '\n') continue;
                return StringUtil.insert(content, "\n", openCurlyBracePosition + 1);
            }
        }
        return content;
    }

    private boolean _isInRegexPattern(String content, int position) {
        int lineNumber = this.getLineNumber(content, position);
        String line = this.getLine(content, lineNumber);
        int lineStartPos = this.getLineStartPos(content, lineNumber);
        int regexPatternStartPos = content.indexOf("~ /", lineStartPos);
        if (regexPatternStartPos == -1 && (regexPatternStartPos = content.indexOf("~/", lineStartPos)) == -1) {
            regexPatternStartPos = content.indexOf(".matches(/", lineStartPos);
        }
        if (regexPatternStartPos == -1) {
            return false;
        }
        int regexPatternEndPos = line.lastIndexOf("/");
        if (regexPatternEndPos == -1) {
            return false;
        }
        regexPatternEndPos = lineStartPos + regexPatternEndPos;
        return position > regexPatternStartPos && position < regexPatternEndPos;
    }

    private boolean _isInSingleLineComment(String content, int position) {
        int lineNumber = this.getLineNumber(content, position);
        String line = this.getLine(content, lineNumber);
        return (line = line.trim()).startsWith("//");
    }

    private String _sortFileNames(String content) {
        Matcher matcher = _fileNamespattern.matcher(content);
        ArrayList<String> fileNames = new ArrayList<String>();
        while (matcher.find()) {
            String match = matcher.group();
            for (String fileName : match.split("\n")) {
                if (Validator.isNull(fileName)) continue;
                fileNames.add(fileName);
            }
            Collections.sort(fileNames, new FileNameComparator());
            StringBundler sb = new StringBundler(fileNames.size() * 2);
            for (String fileName : fileNames) {
                sb.append("\n");
                sb.append(fileName);
            }
            String replacement = sb.toString();
            if (StringUtil.equals(replacement, match)) continue;
            return StringUtil.replaceFirst(content, match, replacement, matcher.start());
        }
        return content;
    }

    private String _sortMapKeys(String mapName, String content) {
        Pattern pattern = Pattern.compile("\n(\t*)(" + mapName + ") = \\[([\\s\\S]*?)\\]\n");
        Matcher matcher1 = pattern.matcher(content);
        if (!matcher1.find()) {
            return content;
        }
        String match = matcher1.group(3);
        if (Validator.isNull(match)) {
            return content;
        }
        TreeMap<String, String> map = new TreeMap<String, String>(new NaturalOrderStringComparator());
        Matcher matcher2 = _mapKeyPattern.matcher(match);
        while (matcher2.find()) {
            map.put(matcher2.group(1), matcher2.group(2));
        }
        StringBundler sb = new StringBundler(map.size() * 9);
        String indent = matcher1.group(1);
        for (Map.Entry entry : map.entrySet()) {
            if (map.size() == 1) {
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append((String)entry.getValue());
                break;
            }
            sb.append('\n');
            sb.append(indent);
            sb.append('\t');
            sb.append((String)entry.getKey());
            sb.append(": ");
            sb.append((String)entry.getValue());
            sb.append(',');
        }
        if (map.size() > 1) {
            sb.setIndex(sb.index() - 1);
            sb.append('\n');
            sb.append(indent);
        }
        return StringUtil.replaceFirst(content, match, sb.toString());
    }

    private String _stylingCheck(String content, Pattern pattern, String replacement) {
        int[] multiLineStringsPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringsPattern);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (SourceUtil.isInsideMultiLines(SourceUtil.getLineNumber(content, matcher.start()), multiLineStringsPositions)) continue;
            return matcher.replaceFirst(replacement);
        }
        return content;
    }

    private class FileNameComparator
    extends PropertyValueComparator {
        private FileNameComparator() {
        }

        @Override
        public int compare(String fileName1, String fileName2) {
            return super.compare(fileName1.substring(fileName1.indexOf("fileNames ") + 10), fileName2.substring(fileName2.indexOf("fileNames ") + 10));
        }
    }
}

