/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.check.util.YMLSourceUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class YMLWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if ((content = this._formatDefinitions(fileName, content, "", 0)).endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return this._removeWhitespace(content);
    }

    private String _formatDefinition(String fileName, String definition, String[] definitionLines, String indent, int level, boolean hasNestedDefinitions) {
        String expectedIndent = "";
        for (int j = 0; j < level; ++j) {
            expectedIndent = expectedIndent + "    ";
        }
        String newDefinition = definition;
        if (!expectedIndent.equals(indent)) {
            newDefinition = expectedIndent + StringUtil.trimLeading(definition);
        }
        if (hasNestedDefinitions) {
            return newDefinition;
        }
        if (definitionLines[0].endsWith("|-")) {
            String leadingSpaces = null;
            int leadingSpacesLength = 0;
            StringBundler sb = new StringBundler(definitionLines.length * 3);
            for (int i = 0; i < definitionLines.length; ++i) {
                if (i == 0) {
                    leadingSpaces = SourceUtil.getLeadingSpaces(definitionLines[i]);
                    leadingSpacesLength = leadingSpaces.length();
                    sb.append(expectedIndent);
                    sb.append(definitionLines[i].substring(leadingSpacesLength));
                    sb.append("\n");
                    continue;
                }
                if (i == 1) {
                    leadingSpaces = SourceUtil.getLeadingSpaces(definitionLines[i]);
                    leadingSpacesLength = leadingSpaces.length();
                }
                sb.append(expectedIndent + "    ");
                sb.append(definitionLines[i].substring(leadingSpacesLength));
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            return sb.toString();
        }
        if (definitionLines.length <= 1) {
            return newDefinition;
        }
        String firstLine = definitionLines[1];
        String newNestedContent = "";
        String oldNestedContent = "";
        String nestedIndent = firstLine.replaceAll("^(\\s+).+", "$1");
        if (nestedIndent.equals(firstLine)) {
            nestedIndent = "";
        }
        for (int j = 1; j < definitionLines.length; ++j) {
            String line = definitionLines[j];
            if (j > 1) {
                newNestedContent = newNestedContent + "\n";
                oldNestedContent = oldNestedContent + "\n";
            }
            newNestedContent = newNestedContent + line;
            oldNestedContent = oldNestedContent + line;
            if (Validator.isNull(line)) continue;
            String curIndent = line.replaceAll("^(\\s+).+", "$1");
            if (curIndent.equals(line)) {
                curIndent = "";
            }
            if (!curIndent.equals(nestedIndent)) continue;
            String trimmedLine = StringUtil.trimLeading(line);
            newNestedContent = StringUtil.replaceLast(newNestedContent, line, expectedIndent + "    " + trimmedLine);
        }
        if (!newNestedContent.equals(oldNestedContent)) {
            if (!this._hasMapInsideList(definitionLines)) {
                newDefinition = StringUtil.replaceFirst(newDefinition, oldNestedContent, newNestedContent);
            } else {
                String message = StringBundler.concat("Incorrect whitespace, expected \"", expectedIndent, "    \"\n", oldNestedContent);
                this.addMessage(fileName, message);
            }
        }
        return newDefinition;
    }

    private String _formatDefinitions(String fileName, String content, String indent, int level) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        String[] lines = content.split("\n");
        if (lines.length == 1) {
            return content;
        }
        int pos = lines[0].length() + 1;
        for (String definition : definitions) {
            String newDefinition;
            lines = definition.split("\n");
            if (lines.length != 0 && lines[0].endsWith("|-")) {
                String newDefinition2 = this._formatDefinition(fileName, definition, lines, indent, level, false);
                if (!newDefinition2.equals(definition)) {
                    content = StringUtil.replaceFirst(content, definition, newDefinition2, 0);
                }
                pos = pos + newDefinition2.length() + 1;
                continue;
            }
            String nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition);
            List<Object> nestedDefinitions = Collections.emptyList();
            if (!nestedDefinitionIndent.equals("")) {
                nestedDefinitions = YMLSourceUtil.getDefinitions(definition, nestedDefinitionIndent);
                newDefinition = this._formatDefinitions(fileName, definition, nestedDefinitionIndent, level + 1);
                if (!newDefinition.equals(definition)) {
                    content = StringUtil.replaceFirst(content, definition, newDefinition, 0);
                    definition = newDefinition;
                }
            }
            if (!(newDefinition = this._formatDefinition(fileName, definition, lines = definition.split("\n"), indent, level, !nestedDefinitions.isEmpty())).equals(definition)) {
                content = StringUtil.replaceFirst(content, definition, newDefinition, pos);
            }
            pos = pos + newDefinition.length() + 1;
        }
        return content;
    }

    private boolean _hasMapInsideList(String[] lines) {
        if (lines.length <= 1) {
            return false;
        }
        String trimmedFirstLine = StringUtil.trimLeading(lines[1]);
        if (!trimmedFirstLine.startsWith("-")) {
            return false;
        }
        for (int j = 1; j < lines.length; ++j) {
            String trimmedLine = StringUtil.trimLeading(lines[j]);
            if (!trimmedLine.matches("\\w+:.*")) continue;
            return true;
        }
        return false;
    }

    private String _removeWhitespace(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = this._removeWhitespaceAfterOpenBracket(line);
                line = this._removeWhitespaceAfterOpenCurlyBrace(line);
                line = this._removeWhitespaceBeforeCloseBracket(line);
                line = this._removeWhitespaceBeforeCloseCurlyBrace(line);
                sb.append(line);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _removeWhitespaceAfterOpenBracket(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("elif [") || trimmedLine.startsWith("if [")) {
            return line;
        }
        int x = line.indexOf("[ ");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "[", "]") != 0) {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceAfterOpenCurlyBrace(String line) {
        int x = line.indexOf("{ ");
        if (x == -1) {
            return line;
        }
        if (x == 0) {
            return StringUtil.replaceFirst(line, " ", "", 0);
        }
        if (ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "{", "}") != 0) {
            return line;
        }
        char c = line.charAt(x - 1);
        if (c == '{') {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceBeforeCloseBracket(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("elif [") || trimmedLine.startsWith("if [")) {
            return line;
        }
        int x = line.indexOf(" ]");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "[", "]") != 0) {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceBeforeCloseCurlyBrace(String line) {
        int x = line.indexOf(" }");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "{", "}") != 0) {
            return line;
        }
        if (x == line.length() - 2) {
            return StringUtil.replaceFirst(line, " ", "", x);
        }
        char c = line.charAt(x + 2);
        if (c == '}') {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }
}

