/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.LegacyPropertiesUtil;
import com.liferay.source.formatter.util.LegacyProperty;
import com.liferay.source.formatter.util.LegacyPropertyAction;
import com.liferay.source.formatter.util.LegacyPropertyType;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;

public class PropertiesVerifyPropertiesCheck
extends BaseFileCheck {
    private static final String _VERIFY_PROPERTIES_FILE_NAME = "portal-impl/src/com/liferay/portal/verify/VerifyProperties.java";
    private List<LegacyProperty> _legacyProperties;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (absolutePath.contains("/modules/")) {
            return content;
        }
        LegacyPropertyType legacyPropertyType = null;
        if (absolutePath.matches(".*/portal([-\\w]+)?\\.properties")) {
            legacyPropertyType = LegacyPropertyType.PORTAL;
        } else if (absolutePath.matches(".*/system([-\\w]+)?\\.properties")) {
            legacyPropertyType = LegacyPropertyType.SYSTEM;
        } else {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        List<LegacyProperty> legacyProperties = this._getLegacyProperties(absolutePath);
        for (LegacyProperty legacyProperty : legacyProperties) {
            if (!properties.containsKey(legacyProperty.getLegacyPropertyName()) || !legacyPropertyType.equals((Object)legacyProperty.getLegacyPropertyType())) continue;
            StringBundler sb = new StringBundler(10);
            sb.append(legacyPropertyType.getValue());
            sb.append(" property \"");
            sb.append(legacyProperty.getLegacyPropertyName());
            LegacyPropertyAction legacyActionType = legacyProperty.getLegacyPropertyAction();
            if (legacyActionType.equals((Object)LegacyPropertyAction.MIGRATED)) {
                sb.append("\" was migrated to ");
                if (legacyPropertyType.equals((Object)LegacyPropertyType.PORTAL)) {
                    sb.append("\"system.properties\"");
                } else {
                    sb.append("\"portal.properties\"");
                }
            } else if (legacyActionType.equals((Object)LegacyPropertyAction.MODULARIZED)) {
                sb.append("\" was modularized");
            } else if (legacyActionType.equals((Object)LegacyPropertyAction.OBSOLETE)) {
                sb.append("\" is obsolete");
            } else {
                sb.append("\" was renamed");
            }
            sb.append(". See \"");
            sb.append(StringUtil.removeSubstring(_VERIFY_PROPERTIES_FILE_NAME, ".java"));
            sb.append("#");
            sb.append(legacyProperty.getVariableName());
            sb.append("\".");
            this.addMessage(fileName, sb.toString());
        }
        return content;
    }

    private synchronized List<LegacyProperty> _getLegacyProperties(String absolutePath) throws Exception {
        if (this._legacyProperties != null) {
            return this._legacyProperties;
        }
        this._legacyProperties = LegacyPropertiesUtil.getLegacyProperties(_VERIFY_PROPERTIES_FILE_NAME, this.getPortalContent(_VERIFY_PROPERTIES_FILE_NAME, absolutePath));
        return this._legacyProperties;
    }
}

