/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;

public class ComponentExposureCheck
extends BaseCheck {
    private static final String _MSG_EXPOSED_STATIC_COMPONENT = "static.component.exposed";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || !importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        this._checkExposedStaticComponent(detailAST, annotationDetailAST);
    }

    private void _checkExposedStaticComponent(DetailAST detailAST, DetailAST annotationDetailAST) {
        if (!this._isEmptyRegisterService(annotationDetailAST)) {
            return;
        }
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        if (ListUtil.isEmpty(methodDefinitionDetailASTList)) {
            return;
        }
        List<DetailAST> variableDefDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 10);
        block0: for (DetailAST variableDefDetailAST : variableDefDetailASTList) {
            String variableName;
            String variableTypeName = this.getVariableTypeName(variableDefDetailAST, variableName = this.getName(variableDefDetailAST), false);
            if (variableTypeName.equals("Log") || !variableDefDetailAST.branchContains(61) || !variableDefDetailAST.branchContains(64)) continue;
            List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefDetailAST);
            for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
                if (!this._isInsidePublicStaticMethod(variableCallerDetailAST)) continue;
                this.log(variableDefDetailAST, _MSG_EXPOSED_STATIC_COMPONENT, new Object[]{variableName});
                continue block0;
            }
        }
    }

    private boolean _isEmptyRegisterService(DetailAST annotationDetailAST) {
        DetailAST serviceAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "service");
        if (serviceAnnotationMemberValuePairDetailAST == null) {
            return false;
        }
        DetailAST annotationArrayInitDetailAST = serviceAnnotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return false;
        }
        DetailAST firstChildDetailAST = annotationArrayInitDetailAST.getFirstChild();
        return firstChildDetailAST.getType() == 73;
    }

    private boolean _isInsidePublicStaticMethod(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            DetailAST modifiersDetailAST;
            if (parentDetailAST.getType() != 9 || !(modifiersDetailAST = parentDetailAST.findFirstToken(5)).branchContains(62) || !modifiersDetailAST.branchContains(64)) continue;
            return true;
        }
        return false;
    }
}

