/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.PropertyNameComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesTestFileCheck
extends BaseFileCheck {
    private static final String _CATEGORIES_LEVELS_KEY = "categoriesLevels";
    private static final String _CATEGORIZED_PROPERTIES_PATTERNS_KEY = "categorizedPropertiesPatterns";
    private static final String _CHECK_TESTRAY_MAIN_COMPONENT_NAME_KEY = "checkTestrayMainComponentName";
    private static final Pattern _sqlPattern1 = Pattern.compile("(?<=\\A|\n) +test\\.batch\\.run\\.property(\\.global)?\\.query.+]=([\\s\\S]*?[^\\\\])(?=(\\Z|\n))");
    private static final Pattern _sqlPattern2 = Pattern.compile("\\s(\\(.* ([!=]=|~) .+\\))( (AND|OR) )?(\\\\)?");
    private List<String> _testrayAllTeamsComponentNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        String sortedTestCategories;
        if (absolutePath.contains("/dependencies/") || !fileName.endsWith("/test.properties")) {
            return content;
        }
        String rootDirName = SourceUtil.getRootDirName(absolutePath);
        if (!rootDirName.equals("") && absolutePath.equals(rootDirName + "/test.properties")) {
            this._checkTestPropertiesOrder(fileName, content);
        } else {
            content = this._generateProperties(absolutePath, content);
            content = StringUtil.trimTrailing(content);
        }
        content = this._formatSQLQuery(content);
        while (!content.equals(sortedTestCategories = this._sortTestCategories(content, "", "##"))) {
            content = sortedTestCategories;
        }
        if (this.isAttributeValue(_CHECK_TESTRAY_MAIN_COMPONENT_NAME_KEY, absolutePath)) {
            this._checkTestrayMainComponentName(fileName, absolutePath, content);
        }
        return content;
    }

    private String _addParenthesis(String sqlClauses) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(sqlClauses));){
            String line = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = StringUtil.trimLeading(line)).startsWith("(") || line.startsWith(")")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                int x = StringUtil.indexOfAny(line, new String[]{" AND \\", " OR \\"});
                if (x == -1) {
                    x = line.lastIndexOf("\\");
                }
                if (x == -1) {
                    sb.append("(");
                    sb.append(line);
                    sb.append(")");
                    sb.append("\n");
                    continue;
                }
                sb.append("(");
                sb.append(line.substring(0, x));
                sb.append(")");
                sb.append(line.substring(x));
                sb.append("\n");
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private Map<String, Map<String, String>> _categorizeProperties(String absolutePath, String content) throws IOException {
        HashMap<String, Map<String, String>> propertiesMap = new HashMap<String, Map<String, String>>();
        List<String> categorizedPropertiesPatterns = this.getAttributeValues(_CATEGORIZED_PROPERTIES_PATTERNS_KEY, absolutePath);
        Properties testProperties = new Properties();
        testProperties.load(new StringReader(content));
        Enumeration<?> enumeration = testProperties.propertyNames();
        block0: while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = testProperties.getProperty(key);
            for (String categorizedPropertiesPattern : categorizedPropertiesPatterns) {
                String[] parts = StringUtil.split(categorizedPropertiesPattern, ":");
                if (parts.length != 2 || !key.matches(parts[1])) continue;
                String categoryName = parts[0];
                HashMap<String, String> properties = (HashMap<String, String>)propertiesMap.get(categoryName);
                if (properties == null) {
                    properties = new HashMap<String, String>();
                }
                properties.put(key, value);
                propertiesMap.put(categoryName, properties);
                continue block0;
            }
            HashMap<String, String> properties = (HashMap<String, String>)propertiesMap.get("Others");
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            properties.put(key, value);
            propertiesMap.put("Others", properties);
        }
        return propertiesMap;
    }

    private String _checkIndentation(String sqlClauses) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(sqlClauses));){
            int level = 2;
            String line = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = line.replaceFirst("^\\( *(\\(.+\\)) *\\)$", "$1");
                sb.append(this._fixIndentation(line, level));
                sb.append("\n");
                level += this.getLevel(line, "(", ")");
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private void _checkTestPropertiesOrder(String fileName, String content) {
        String commentCategory = null;
        String commentPrefix = null;
        String previousLine = null;
        String previousPropertyKey = null;
        String[] lines = content.split("\n");
        int lineNumber = 0;
        for (String line : lines) {
            ++lineNumber;
            if ((line.startsWith("##") || line.startsWith("    #")) && !line.contains("=")) {
                if (commentPrefix == null) {
                    commentCategory = line;
                    commentPrefix = line;
                    continue;
                }
                if (line.startsWith(commentPrefix) && !line.contains("=")) {
                    commentCategory = commentCategory + "\n" + line;
                    continue;
                }
            }
            if (commentCategory != null && commentCategory.startsWith(commentPrefix + "\n") && commentCategory.endsWith("\n" + commentPrefix)) {
                commentCategory = null;
                commentPrefix = null;
                previousLine = null;
                previousPropertyKey = null;
            }
            if (commentCategory != null && !Validator.isBlank(line) && !line.startsWith("    ")) {
                this.addMessage(fileName, "Incorrect indentation on line " + lineNumber);
                return;
            }
            int x = line.indexOf(61);
            if (x == -1 || previousLine != null && previousLine.endsWith("\\")) {
                previousLine = line;
                continue;
            }
            String propertyKey = StringUtil.trimLeading(line.substring(0, x));
            if (propertyKey.startsWith("#")) {
                propertyKey = propertyKey.substring(1);
            }
            if (Validator.isNull(previousPropertyKey)) {
                previousLine = line;
                previousPropertyKey = propertyKey;
                continue;
            }
            PropertyNameComparator propertyNameComparator = new PropertyNameComparator();
            int compare = propertyNameComparator.compare(previousPropertyKey, propertyKey);
            if (compare > 0) {
                this.addMessage(fileName, StringBundler.concat("Incorrect order of properties: \"", propertyKey, "\" should come before \"", previousPropertyKey, "\""), lineNumber);
            }
            previousLine = line;
            previousPropertyKey = propertyKey;
        }
    }

    private void _checkTestrayMainComponentName(String fileName, String absolutePath, String content) throws IOException {
        if (!this.isModulesFile(absolutePath) || absolutePath.contains("/modules/apps/archived/")) {
            return;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        String testrayMainComponentName = properties.getProperty("testray.main.component.name");
        if (testrayMainComponentName == null) {
            return;
        }
        List<String> testrayAllTeamsComponentNames = this._getTestrayAllTeamsComponentNames();
        if (!testrayAllTeamsComponentNames.contains(testrayMainComponentName)) {
            this.addMessage(fileName, StringBundler.concat("Property value \"", testrayMainComponentName, "\" does not exist in \"testray.team.*.component.names\" ", "in ", SourceUtil.getRootDirName(absolutePath), "/test.properties"));
        }
    }

    private int _compareTo(String sqlClause, String nextSQLClause) {
        if (sqlClause.endsWith("\")") && nextSQLClause.endsWith("\")")) {
            sqlClause = sqlClause.substring(0, sqlClause.length() - 2);
            nextSQLClause = nextSQLClause.substring(0, nextSQLClause.length() - 2);
        }
        return sqlClause.compareTo(nextSQLClause);
    }

    private String _fixIndentation(String line, int level) {
        String trimmedLine = StringUtil.trim(line);
        if (Validator.isNull(trimmedLine)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; !(i >= level || i == level - 1 && trimmedLine.startsWith(")")); ++i) {
            sb.append("    ");
        }
        sb.append(trimmedLine);
        return sb.toString();
    }

    private String _formatSQLQuery(String content) throws IOException {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _sqlPattern1.matcher(content);
        block0: while (matcher.find()) {
            String originalSqlClauses = matcher.group(2);
            String sqlClauses = originalSqlClauses.replaceAll("\\\\\n *", "");
            sqlClauses = sqlClauses.replaceAll("\\( +\\(", "((");
            int x = (sqlClauses = sqlClauses.replaceAll("\\) +\\)", "))")).indexOf("(");
            if (x == -1) continue;
            int y = x;
            String s = "";
            while ((y = sqlClauses.indexOf(")", y + 1)) != -1) {
                s = sqlClauses.substring(x, y + 1);
                int level = this.getLevel(s);
                if (level != 0) continue;
                x = (sqlClauses = StringUtil.replaceFirst(sqlClauses, s, this._removeRedundantParenthesis(s), x)).indexOf("(", x + 1);
                if (x != -1) {
                    y = x;
                    continue;
                }
                sqlClauses = StringUtil.replace(sqlClauses, " AND ", " AND \\\n");
                sqlClauses = StringUtil.replace(sqlClauses, " OR ", " OR \\\n");
                sqlClauses = this._addParenthesis(sqlClauses);
                sqlClauses = this._checkIndentation(sqlClauses);
                sqlClauses = this._sort(sqlClauses);
                sqlClauses = "\\\n" + sqlClauses;
                if (originalSqlClauses.endsWith("\\\n")) {
                    sqlClauses = sqlClauses + "\n";
                }
                if (sqlClauses.equals(originalSqlClauses)) continue block0;
                String replacement = StringUtil.replaceFirst(matcher.group(), matcher.group(2), sqlClauses);
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
                continue block0;
            }
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    private String _generateProperties(String absolutePath, String content) throws IOException {
        Map<String, Map<String, String>> categorizedProperties = this._categorizeProperties(absolutePath, content);
        if (MapUtil.isEmpty(categorizedProperties)) {
            return content;
        }
        List<String> categoriesLevels = this.getAttributeValues(_CATEGORIES_LEVELS_KEY, absolutePath);
        if (ListUtil.isEmpty(categoriesLevels)) {
            return content;
        }
        String properties = "";
        for (String categoriesLevel : categoriesLevels) {
            String mergedSubcategoriesProperties = "";
            String[] parts = StringUtil.split(categoriesLevel, ":");
            for (int j = parts.length - 1; j > 0; --j) {
                String mergedSubcategoryProperties = this._mergeProperties(false, parts[j], categorizedProperties.get(parts[j]));
                mergedSubcategoriesProperties = mergedSubcategoryProperties + mergedSubcategoriesProperties;
            }
            String mergedTopCategoryProperties = this._mergeProperties(true, parts[0], categorizedProperties.get(parts[0]));
            if (Validator.isBlank(mergedSubcategoriesProperties) && !mergedTopCategoryProperties.contains("=")) continue;
            properties = mergedTopCategoryProperties + mergedSubcategoriesProperties + properties;
        }
        return properties;
    }

    private String _getSQLClause(String line) {
        Matcher matcher = _sqlPattern2.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private synchronized List<String> _getTestrayAllTeamsComponentNames() throws IOException {
        if (this._testrayAllTeamsComponentNames != null) {
            return this._testrayAllTeamsComponentNames;
        }
        this._testrayAllTeamsComponentNames = new ArrayList<String>();
        File file = new File(this.getPortalDir(), "test.properties");
        if (!file.exists()) {
            return this._testrayAllTeamsComponentNames;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        List<String> testrayAvailableComponentNames = ListUtil.fromString(properties.getProperty("testray.available.component.names"), ",");
        for (String testrayAvailableComponentName : testrayAvailableComponentNames) {
            String testrayTeamComponentName;
            List<String> testrayTeamComponentNames;
            if (!testrayAvailableComponentName.startsWith("${") && !testrayAvailableComponentName.endsWith("}") || ListUtil.isEmpty(testrayTeamComponentNames = ListUtil.fromString(properties.getProperty(testrayTeamComponentName = testrayAvailableComponentName.substring(2, testrayAvailableComponentName.length() - 1)), ","))) continue;
            this._testrayAllTeamsComponentNames.addAll(testrayTeamComponentNames);
        }
        return this._testrayAllTeamsComponentNames;
    }

    private String _mergeProperties(boolean topLevel, String categoryName, Map<String, String> properitesMap) {
        if (MapUtil.isEmpty(properitesMap) && !topLevel) {
            return "";
        }
        String comment = "    ";
        if (topLevel) {
            comment = "#";
        }
        comment = comment + "#";
        String categoryHeader = StringBundler.concat(comment, "\n", comment, " ", categoryName, "\n", comment, "\n\n");
        if (MapUtil.isEmpty(properitesMap) && topLevel) {
            return categoryHeader;
        }
        StringBundler sb = new StringBundler(categoryHeader);
        ArrayList<String> keys = new ArrayList<String>(properitesMap.keySet());
        Collections.sort(keys, new PropertyNameComparator());
        for (int i = 0; i < keys.size(); ++i) {
            boolean multiLine = false;
            String key = (String)keys.get(i);
            String[] values = StringUtil.split(properitesMap.get(key));
            if (values.length == 1 && !StringUtil.equals(values[0], "**")) {
                int lineLength = 5 + key.length() + values[0].length();
                if (lineLength > this.getMaxLineLength()) {
                    multiLine = true;
                }
            } else if (values.length > 1) {
                multiLine = true;
            }
            if (multiLine && !StringUtil.endsWith(sb.toString(), "\n\n")) {
                sb.append("\n");
            }
            sb.append("    ");
            sb.append(key);
            sb.append("=");
            if (multiLine) {
                for (String value : values) {
                    sb.append("\\\n        ");
                    sb.append(value);
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("\n\n");
                continue;
            }
            sb.append(values);
            if (i == keys.size() - 1) {
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _removeRedundantParenthesis(String sqlClause) {
        int x = -1;
        while ((x = StringUtil.indexOfAny(sqlClause, new String[]{" AND ", " OR "}, x + 1)) != -1) {
            int level1 = this.getLevel(sqlClause.substring(0, x));
            int level2 = this.getLevel(sqlClause.substring(x));
            if (level1 != 1 || level2 != -1) continue;
            sqlClause = StringUtil.insert(sqlClause, "\\\n", sqlClause.length() - 1);
            sqlClause = StringUtil.insert(sqlClause, "\\\n", 1);
            return sqlClause;
        }
        if (sqlClause.startsWith("((")) {
            return this._removeRedundantParenthesis(sqlClause.substring(1, sqlClause.length() - 1));
        }
        return sqlClause;
    }

    private String _sort(String sqlClauses) {
        Matcher matcher = _sqlPattern2.matcher(sqlClauses);
        while (matcher.find()) {
            String sqlClause;
            String nextSQLClause;
            int lineNumber = this.getLineNumber(sqlClauses, matcher.start());
            if (Validator.isNull(matcher.group(4)) || (nextSQLClause = this._getSQLClause(SourceUtil.getLine(sqlClauses, lineNumber + 1))) == null || this._compareTo(sqlClause = matcher.group(1), nextSQLClause) <= 0) continue;
            sqlClauses = StringUtil.replaceFirst(sqlClauses, nextSQLClause, sqlClause, this.getLineStartPos(sqlClauses, lineNumber + 1));
            return StringUtil.replaceFirst(sqlClauses, sqlClause, nextSQLClause, this.getLineStartPos(sqlClauses, lineNumber));
        }
        return sqlClauses;
    }

    private String _sortTestCategories(String content, String indent, String pounds) {
        String indentWithPounds = indent + pounds;
        CommentComparator comparator = new CommentComparator();
        Pattern pattern = Pattern.compile(StringBundler.concat("((?<=\\A|\n\n)", indentWithPounds, "\n", indentWithPounds, "( .+)\n", indentWithPounds, "\n\n[\\s\\S]*?)(?=(\n\n", indentWithPounds, "\n|\\Z))"));
        Matcher matcher = pattern.matcher(content);
        String previousProperties = null;
        String previousPropertiesComment = null;
        int previousPropertiesStartPosition = -1;
        while (matcher.find()) {
            String newProperties;
            String properties = matcher.group(1);
            String propertiesComment = matcher.group(2);
            int propertiesStartPosition = matcher.start();
            if (pounds.length() == 2 && !(newProperties = this._sortTestCategories(properties, indent + "    ", "#")).equals(properties)) {
                return StringUtil.replaceFirst(content, properties, newProperties, propertiesStartPosition);
            }
            if (Validator.isNull(previousProperties)) {
                previousProperties = properties;
                previousPropertiesComment = propertiesComment;
                previousPropertiesStartPosition = propertiesStartPosition;
                continue;
            }
            int value = comparator.compare(previousPropertiesComment, propertiesComment);
            if (value > 0) {
                content = StringUtil.replaceFirst(content, properties, previousProperties, propertiesStartPosition);
                content = StringUtil.replaceFirst(content, previousProperties, properties, previousPropertiesStartPosition);
                return content;
            }
            previousProperties = properties;
            previousPropertiesComment = propertiesComment;
            previousPropertiesStartPosition = propertiesStartPosition;
        }
        return content;
    }

    private class CommentComparator
    extends NaturalOrderStringComparator {
        private CommentComparator() {
        }

        @Override
        public int compare(String comment1, String comment2) {
            if (comment1.equals(" Default") || comment2.equals(" Others")) {
                return -1;
            }
            if (comment2.equals(" Default") || comment1.equals(" Others")) {
                return 1;
            }
            return super.compare(comment1, comment2);
        }
    }
}

