/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import java.io.IOException;
import java.util.Map;

public class JSPOutputTaglibsCheck
extends BaseTagAttributesCheck {
    private static final String[] _OUTPUT_TAGLIB_NAMES = new String[]{"liferay-util:body-bottom", "liferay-util:body-top", "liferay-util:html-bottom", "liferay-util:html-top"};

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        String bundleSymbolicName = this._getBundleSymbolicName(fileName);
        if (bundleSymbolicName == null) {
            return content;
        }
        int x = fileName.lastIndexOf("/src/main/resources/META-INF/resources/");
        if (x == -1) {
            return content;
        }
        String expectedValue = StringBundler.concat(bundleSymbolicName, "#", fileName.substring(x + 38));
        this._checkOutputKey(fileName, content, expectedValue);
        return content;
    }

    private void _checkOutputKey(String fileName, String content, String expectedValue) {
        for (String outputTaglibName : _OUTPUT_TAGLIB_NAMES) {
            String taglibName = "<" + outputTaglibName;
            int x = -1;
            while ((x = content.indexOf(taglibName, x + 1)) != -1) {
                Map<String, String> attributesMap;
                String attributeValue;
                BaseTagAttributesCheck.Tag tag = this.parseTag(this.getTag(content, x), false);
                if (tag == null || (attributeValue = (attributesMap = tag.getAttributesMap()).get("outputKey")) == null || attributeValue.contains("<%") || attributeValue.startsWith(expectedValue)) continue;
                this.addMessage(fileName, StringBundler.concat("The value for \"outputKey\" in <", outputTaglibName, "> should start with \"", expectedValue, "\""), this.getLineNumber(content, x));
            }
        }
    }

    private String _getBundleSymbolicName(String fileName) throws IOException {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return null;
        }
        return BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
    }
}

