/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedundantLogCheck
extends BaseCheck {
    private static final String _MSG_REDUNDANT_LOG = "log.redundant";
    private static final Pattern _logLevelPattern = Pattern.compile("_log.is(Debug|Error|Info|Trace|Warn)Enabled");

    public int[] getDefaultTokens() {
        return new int[]{83};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 92) {
            return;
        }
        this._checkRedundantLog(detailAST, null, detailAST.getLineNo());
    }

    private void _checkRedundantLog(DetailAST detailAST, DetailAST previousElistDetailAST, int startLineNumber) {
        DetailAST exprDetailAST = detailAST.findFirstToken(28);
        DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 27) {
            return;
        }
        Matcher matcher = _logLevelPattern.matcher(this._getMethodCallFullIdent(firstChildDetailAST));
        if (!matcher.find()) {
            return;
        }
        DetailAST slistDetailAST = detailAST.findFirstToken(7);
        firstChildDetailAST = slistDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return;
        }
        for (DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling(); nextSiblingDetailAST != null; nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) {
            if (nextSiblingDetailAST.getType() == 73 || nextSiblingDetailAST.getType() == 45) continue;
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 27) {
            return;
        }
        String methodCallFullIdent = this._getMethodCallFullIdent(firstChildDetailAST);
        if (!methodCallFullIdent.matches("_log\\." + StringUtil.lowerCaseFirstLetter(matcher.group(1)))) {
            return;
        }
        DetailAST elistDetailAST = firstChildDetailAST.findFirstToken(34);
        DetailAST literalElseDetailAST = detailAST.findFirstToken(92);
        if (literalElseDetailAST == null) {
            if (this._compareDetailAST(elistDetailAST, previousElistDetailAST)) {
                this.log(startLineNumber, _MSG_REDUNDANT_LOG, new Object[]{startLineNumber, this.getEndLineNumber(slistDetailAST)});
            }
            return;
        }
        firstChildDetailAST = literalElseDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 83) {
            return;
        }
        this._checkRedundantLog(firstChildDetailAST, elistDetailAST, startLineNumber);
    }

    private boolean _compareDetailAST(DetailAST detailAST1, DetailAST detailAST2) {
        DetailAST nextSiblingDetailAST2;
        DetailAST nextSiblingDetailAST1;
        if (detailAST1 == null || detailAST2 == null) {
            return detailAST1 == detailAST2;
        }
        while (true) {
            if (detailAST1.getType() != detailAST2.getType() || !StringUtil.equals(detailAST1.getText(), detailAST2.getText()) || !this._compareDetailAST(detailAST1.getFirstChild(), detailAST2.getFirstChild())) {
                return false;
            }
            nextSiblingDetailAST1 = detailAST1.getNextSibling();
            nextSiblingDetailAST2 = detailAST2.getNextSibling();
            if (nextSiblingDetailAST1 == null || nextSiblingDetailAST2 == null) break;
            detailAST1 = nextSiblingDetailAST1;
            detailAST2 = nextSiblingDetailAST2;
        }
        return nextSiblingDetailAST1 == nextSiblingDetailAST2;
    }

    private String _getMethodCallFullIdent(DetailAST detailAST) {
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return this.getName(detailAST);
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST);
        return fullIdent.getText();
    }
}

