/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import java.io.IOException;
import java.io.Writer;

public class UnsyncBufferedWriter
extends Writer {
    private static final int _DEFAULT_BUFFER_SIZE = 8192;
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private char[] _buffer;
    private int _count;
    private int _size;
    private Writer _writer;

    public UnsyncBufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public UnsyncBufferedWriter(Writer writer, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 1");
        }
        this._writer = writer;
        this._size = size;
        this._buffer = new char[size];
    }

    @Override
    public void close() throws IOException {
        if (this._writer == null) {
            return;
        }
        this.flush();
        this._writer.close();
        this._writer = null;
        this._buffer = null;
    }

    @Override
    public void flush() throws IOException {
        if (this._writer == null) {
            throw new IOException("Writer is null");
        }
        if (this._count > 0) {
            this._writer.write(this._buffer, 0, this._count);
            this._count = 0;
        }
        this._writer.flush();
    }

    public void newLine() throws IOException {
        this.write(_LINE_SEPARATOR);
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        if (this._writer == null) {
            throw new IOException("Writer is null");
        }
        BoundaryCheckerUtil.check(chars.length, offset, length);
        if (length >= this._size) {
            if (this._count > 0) {
                this._writer.write(this._buffer, 0, this._count);
                this._count = 0;
            }
            this._writer.write(chars, offset, length);
            return;
        }
        if (this._count > 0 && length > this._size - this._count) {
            this._writer.write(this._buffer, 0, this._count);
            this._count = 0;
        }
        System.arraycopy(chars, offset, this._buffer, this._count, length);
        this._count += length;
    }

    @Override
    public void write(int c) throws IOException {
        if (this._writer == null) {
            throw new IOException("Writer is null");
        }
        if (this._count >= this._size) {
            this._writer.write(this._buffer);
            this._count = 0;
        }
        this._buffer[this._count++] = (char)c;
    }

    @Override
    public void write(String string, int offset, int length) throws IOException {
        if (this._writer == null) {
            throw new IOException("Writer is null");
        }
        BoundaryCheckerUtil.check(string.length(), offset, length);
        int x = offset;
        int y = offset + length;
        while (x < y) {
            int leftDataSize;
            int leftFreeSpace;
            if (this._count >= this._size) {
                this._writer.write(this._buffer);
                this._count = 0;
            }
            if ((leftFreeSpace = this._size - this._count) > (leftDataSize = y - x)) {
                string.getChars(x, y, this._buffer, this._count);
                this._count += leftDataSize;
                break;
            }
            int copyEnd = x + leftFreeSpace;
            string.getChars(x, copyEnd, this._buffer, this._count);
            this._count += leftFreeSpace;
            x = copyEnd;
        }
    }
}

