/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ResourceImplCheck
extends BaseCheck {
    private static final String[] _ALLOWED_ANNOTATIONS = new String[]{"NestedFieldId", "PathParam"};
    private static final String _MSG_INVALID_METHOD_PARAMETER_ANNOTATION = "invalid.method.parameter.annotation";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.contains("/internal/resource/")) {
            return;
        }
        String className = this.getName(detailAST);
        if (!className.endsWith("ResourceImpl") || className.startsWith("Base")) {
            return;
        }
        this._checkMethodDefinitions(detailAST);
    }

    private void _checkMethodDefinitions(DetailAST classDefinitionDetailAST) {
        for (DetailAST methodDefinitionDetailAST : this.getAllChildTokens(classDefinitionDetailAST, true, 9)) {
            String methodName = this.getName(methodDefinitionDetailAST);
            for (DetailAST parameterDefinitionDetailAST : this.getAllChildTokens(methodDefinitionDetailAST, true, 21)) {
                DetailAST modifiersDetailAST = parameterDefinitionDetailAST.findFirstToken(5);
                for (DetailAST annotationDetailAST : this.getAllChildTokens(modifiersDetailAST, false, 159)) {
                    String annotationName = this.getName(annotationDetailAST);
                    if (ArrayUtil.contains(_ALLOWED_ANNOTATIONS, annotationName)) continue;
                    this.log(annotationDetailAST, _MSG_INVALID_METHOD_PARAMETER_ANNOTATION, new Object[]{annotationName, methodName});
                }
            }
        }
    }
}

