/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;

public class OSGiCommandsCheck
extends BaseCheck {
    private static final String _MSG_COMMAND_FUNCTION_MISSING = "command.function.missing";
    private static final String _MSG_OSGI_REFERENCE_AVOID = "osgi.reference.avoid";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST implementsClauseDetailAST = detailAST.findFirstToken(19);
        if (implementsClauseDetailAST == null) {
            return;
        }
        List<String> implementedClassNames = this.getNames(implementsClauseDetailAST, false);
        if (!implementedClassNames.contains("OSGiCommands")) {
            return;
        }
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        if (objBlockDetailAST == null) {
            return;
        }
        List<String> importNames = this.getImportNames(detailAST);
        if (importNames.contains("org.osgi.service.component.annotations.Component")) {
            this._checkMissingUnimplementedMethod(detailAST, objBlockDetailAST);
        }
        if (importNames.contains("org.osgi.service.component.annotations.Reference")) {
            this._checkVariableDeclaration(objBlockDetailAST);
        }
    }

    private void _checkMissingUnimplementedMethod(DetailAST detailAST, DetailAST objBlockDetailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST annotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (annotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = annotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        List<String> osgiCommandFunctions = this._getOSGiCommandFunctions(annotationArrayInitDetailAST);
        if (osgiCommandFunctions.isEmpty()) {
            return;
        }
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            osgiCommandFunctions.remove(this.getName(methodDefinitionDetailAST));
        }
        for (String osgiCommandFunction : osgiCommandFunctions) {
            this.log(detailAST, _MSG_COMMAND_FUNCTION_MISSING, new Object[]{osgiCommandFunction});
        }
    }

    private void _checkVariableDeclaration(DetailAST objBlockDetailAST) {
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            String typeName;
            if (!AnnotationUtil.containsAnnotation((DetailAST)variableDefinitionDetailAST, (String)"Reference") || !(typeName = this.getTypeName(variableDefinitionDetailAST, false)).endsWith("OSGiCommands")) continue;
            this.log(variableDefinitionDetailAST, _MSG_OSGI_REFERENCE_AVOID, new Object[0]);
        }
    }

    private List<String> _getOSGiCommandFunctions(DetailAST annotationArrayInitDetailAST) {
        ArrayList<String> osgiCommandFunctions = new ArrayList<String>();
        for (DetailAST expressionDetailAST : this.getAllChildTokens(annotationArrayInitDetailAST, false, 28)) {
            String[] property;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(property = StringUtil.split(StringUtil.unquote(firstChildDetailAST.getText()), '='))[0].equals("osgi.command.function")) continue;
            osgiCommandFunctions.add(property[1]);
        }
        return osgiCommandFunctions;
    }
}

