<%--
/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */
--%>

<%@ include file="/init.jsp" %>

<%
ViewSharedWithMeSectionDisplayContext viewSharedWithMeSectionDisplayContext = (ViewSharedWithMeSectionDisplayContext)request.getAttribute(ViewSharedWithMeSectionDisplayContext.class.getName());
%>

<div>
	<div>
		<react:component
			module="{Breadcrumb} from site-cms-site-initializer"
			props="<%= viewSharedWithMeSectionDisplayContext.getBreadcrumbProps() %>"
		/>
	</div>

	<div class="cms-section custom-empty-state">
		<frontend-data-set:headless-display
			additionalProps="<%= viewSharedWithMeSectionDisplayContext.getAdditionalProps() %>"
			apiURL="<%= viewSharedWithMeSectionDisplayContext.getAPIURL() %>"
			emptyState="<%= viewSharedWithMeSectionDisplayContext.getEmptyState() %>"
			fdsActionDropdownItems="<%= viewSharedWithMeSectionDisplayContext.getFDSActionDropdownItems() %>"
			formName="fm"
			id="<%= CMSSiteInitializerFDSNames.SHARED_WITH_ME %>"
			itemsPerPage="<%= 20 %>"
			propsTransformer="{SharedWithMeFDSPropsTransformer} from site-cms-site-initializer"
			selectedItemsKey="id"
			selectionType="multiple"
			style="fluid"
		/>
	</div>
</div>