/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.internal.configuration.SharingCompanyConfiguration;
import com.liferay.sharing.internal.configuration.SharingGroupConfiguration;
import com.liferay.sharing.internal.configuration.SharingSystemConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.sharing.internal.configuration.SharingSystemConfiguration"}, service={SharingConfigurationFactory.class})
public class SharingConfigurationFactoryImpl
implements SharingConfigurationFactory {
    private static final Log _log = LogFactoryUtil.getLog(SharingConfigurationFactoryImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile SharingSystemConfiguration _sharingSystemConfiguration;

    public SharingConfiguration getCompanySharingConfiguration(Company company) {
        return this._getSharingConfiguration(company.getCompanyId(), null);
    }

    public SharingConfiguration getGroupSharingConfiguration(Group group) {
        return this._getSharingConfiguration(group.getCompanyId(), group);
    }

    public SharingConfiguration getSystemSharingConfiguration() {
        return new SharingConfigurationImpl(null, null, null, this._sharingSystemConfiguration);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._sharingSystemConfiguration = (SharingSystemConfiguration)ConfigurableUtil.createConfigurable(SharingSystemConfiguration.class, properties);
    }

    private SharingConfiguration _getSharingConfiguration(long companyId, Group group) {
        try {
            SharingGroupConfiguration sharingGroupConfiguration = null;
            if (group != null) {
                sharingGroupConfiguration = (SharingGroupConfiguration)this._configurationProvider.getGroupConfiguration(SharingGroupConfiguration.class, group.getGroupId());
            }
            SharingCompanyConfiguration sharingCompanyConfiguration = (SharingCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SharingCompanyConfiguration.class, companyId);
            return new SharingConfigurationImpl(group, sharingGroupConfiguration, sharingCompanyConfiguration, this._sharingSystemConfiguration);
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return new SharingConfigurationImpl(null, null, null, this._sharingSystemConfiguration);
        }
    }

    private static class SharingConfigurationImpl
    implements SharingConfiguration {
        private final Group _group;
        private final SharingCompanyConfiguration _sharingCompanyConfiguration;
        private final SharingGroupConfiguration _sharingGroupConfiguration;
        private final SharingSystemConfiguration _sharingSystemConfiguration;

        public SharingConfigurationImpl(Group group, SharingGroupConfiguration sharingGroupConfiguration, SharingCompanyConfiguration sharingCompanyConfiguration, SharingSystemConfiguration sharingSystemConfiguration) {
            this._group = group;
            this._sharingGroupConfiguration = sharingGroupConfiguration;
            this._sharingCompanyConfiguration = sharingCompanyConfiguration;
            this._sharingSystemConfiguration = sharingSystemConfiguration;
        }

        public boolean isAvailable() {
            if (!this._sharingSystemConfiguration.enabled() || this._sharingCompanyConfiguration != null && !this._sharingCompanyConfiguration.enabled()) {
                return false;
            }
            return this._group == null || !this._group.isStagingGroup();
        }

        public boolean isEnabled() {
            if (!this._sharingSystemConfiguration.enabled() || this._sharingCompanyConfiguration != null && !this._sharingCompanyConfiguration.enabled()) {
                return false;
            }
            if (this._group == null) {
                return true;
            }
            if (this._group.isStagingGroup()) {
                return false;
            }
            UnicodeProperties typeSettingsUnicodeProperties = this._group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties.containsKey((Object)"sharingEnabled")) {
                return GetterUtil.getBoolean((String)((String)typeSettingsUnicodeProperties.get((Object)"sharingEnabled")));
            }
            if (this._sharingGroupConfiguration == null) {
                return true;
            }
            return this._sharingGroupConfiguration.enabled();
        }
    }
}

