/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sharing.model.impl;

import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalServiceUtil;

/**
 * The extended model base implementation for the SharingEntry service. Represents a row in the &quot;SharingEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SharingEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SharingEntryImpl
 * @see SharingEntry
 * @generated
 */
public abstract class SharingEntryBaseImpl
	extends SharingEntryModelImpl implements SharingEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sharing entry model instance should use the <code>SharingEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SharingEntryLocalServiceUtil.addSharingEntry(this);
		}
		else {
			SharingEntryLocalServiceUtil.updateSharingEntry(this);
		}
	}

}