/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.security.permission;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.security.permission.SharingPermission;
import com.liferay.sharing.security.permission.SharingPermissionChecker;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SharingPermission.class})
public class SharingPermissionImpl
implements SharingPermission {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ServiceTrackerMap<Long, SharingPermissionChecker> _serviceTrackerMap;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;

    public void check(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId, Collection<SharingEntryAction> sharingEntryActions) throws PortalException {
        if (!this.contains(permissionChecker, classNameId, classPK, groupId, sharingEntryActions)) {
            ClassName className = this._classNameLocalService.fetchByClassNameId(classNameId);
            String resourceName = String.valueOf(classNameId);
            if (className != null) {
                resourceName = className.getClassName();
            }
            Stream<SharingEntryAction> sharingEntryActionsStream = sharingEntryActions.stream();
            throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), resourceName, classPK, (String[])sharingEntryActionsStream.map(SharingEntryAction::getActionId).toArray(String[]::new));
        }
    }

    public void checkManageCollaboratorsPermission(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId) throws PortalException {
        if (!this.containsManageCollaboratorsPermission(permissionChecker, classNameId, classPK, groupId)) {
            throw new PrincipalException(StringBundler.concat((Object[])new Object[]{"User ", permissionChecker.getUserId(), " does not have permission to manage collaborators of ", "entry with class name ", classNameId, " and class PK ", classPK}));
        }
    }

    public void checkSharePermission(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId) throws PortalException {
        if (!this.containsSharePermission(permissionChecker, classNameId, classPK, groupId)) {
            throw new PrincipalException(StringBundler.concat((Object[])new Object[]{"User ", permissionChecker.getUserId(), " does not have permission to share ", classNameId, " ", classPK}));
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId, Collection<SharingEntryAction> sharingEntryActions) throws PortalException {
        SharingPermissionChecker sharingPermissionChecker = (SharingPermissionChecker)this._serviceTrackerMap.getService((Object)classNameId);
        if (sharingPermissionChecker == null) {
            throw new PrincipalException("sharing permission checker is null for class name ID " + classNameId);
        }
        if (sharingPermissionChecker.hasPermission(permissionChecker, classPK, groupId, sharingEntryActions)) {
            return true;
        }
        Stream<SharingEntryAction> sharingEntryActionsStream = sharingEntryActions.stream();
        return sharingEntryActionsStream.allMatch(sharingEntryAction -> this._sharingEntryLocalService.hasShareableSharingPermission(permissionChecker.getUserId(), classNameId, classPK, sharingEntryAction));
    }

    public boolean containsManageCollaboratorsPermission(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId) throws PortalException {
        if (permissionChecker.isGroupAdmin(groupId)) {
            return true;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        if (assetEntry == null) {
            return false;
        }
        if (assetEntry.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(permissionChecker.getUserId(), classNameId, classPK);
        return sharingEntry != null && sharingEntry.isShareable() && this.contains(permissionChecker, sharingEntry.getClassNameId(), sharingEntry.getClassPK(), sharingEntry.getGroupId(), Collections.singletonList(SharingEntryAction.UPDATE));
    }

    public boolean containsSharePermission(PermissionChecker permissionChecker, long classNameId, long classPK, long groupId) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        if (assetEntry == null) {
            return false;
        }
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin() || permissionChecker.isGroupAdmin(groupId) || permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), assetEntry.getClassName(), classPK, assetEntry.getUserId(), "VIEW")) {
            return true;
        }
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(permissionChecker.getUserId(), classNameId, classPK);
        return sharingEntry != null && sharingEntry.isShareable();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SharingPermissionChecker.class, (String)"(model.class.name=*)", (serviceReference, emitter) -> emitter.emit((Object)this._classNameLocalService.getClassNameId((String)serviceReference.getProperty("model.class.name"))));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

