/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.servlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.server.manager.internal.executor.Executor;
import com.liferay.server.manager.internal.executor.ExecutorPathResolver;
import com.liferay.server.manager.internal.executor.ExecutorServiceRegistry;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.server.manager.internal.servlet.ServerManagerServlet", "osgi.http.whiteboard.servlet.pattern=/server-manager/*", "servlet.init.httpMethods=DELETE,GET,POST,PUT"}, service={Servlet.class})
public class ServerManagerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(ServerManagerServlet.class);
    @Reference
    private ExecutorServiceRegistry _executorServiceRegistry;
    @Reference
    private Portal _portal;

    protected void execute(HttpServletRequest request, JSONObject responseJSONObject, String pathInfo) throws Exception {
        String executorPath = this.getExecutorPath(pathInfo);
        Executor executor = this._executorServiceRegistry.getExecutor(executorPath);
        Queue<String> arguments = this.getExecutorArguments(executorPath, pathInfo);
        String method = request.getMethod();
        if (StringUtil.equalsIgnoreCase((String)method, (String)"DELETE")) {
            executor.executeDelete(request, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"GET")) {
            executor.executeRead(request, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"POST")) {
            executor.executeCreate(request, responseJSONObject, arguments);
        } else if (StringUtil.equalsIgnoreCase((String)method, (String)"PUT")) {
            executor.executeUpdate(request, responseJSONObject, arguments);
        }
    }

    protected Queue<String> getExecutorArguments(String matchingExecutorPath, String pathInfo) {
        String[] pathParts;
        LinkedList<String> arguments = new LinkedList<String>();
        String path = StringUtil.toLowerCase((String)pathInfo);
        path = StringUtil.replace((String)path, (String)(matchingExecutorPath + "/"), (String)"");
        for (String pathPart : pathParts = StringUtil.split((String)path, (String)"/")) {
            arguments.add(pathPart);
        }
        return arguments;
    }

    protected String getExecutorPath(String pathInfo) {
        ExecutorPathResolver executorPathResolver = new ExecutorPathResolver(this._executorServiceRegistry.getAvailableExecutorPaths());
        return executorPathResolver.getExecutorPath(pathInfo);
    }

    protected boolean isValidUser(HttpServletRequest request) {
        try {
            User user = this._portal.getUser(request);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            if (permissionChecker.isOmniadmin()) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isValidUser(request)) {
            response.setStatus(401);
            return;
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject();
        responseJSONObject.put("error", "");
        responseJSONObject.put("output", "");
        responseJSONObject.put("status", 0);
        try {
            this.execute(request, responseJSONObject, request.getPathInfo());
        }
        catch (Exception e) {
            responseJSONObject.put("error", StackTraceUtil.getStackTrace((Throwable)e));
            responseJSONObject.put("status", 1);
        }
        String format = ParamUtil.getString((HttpServletRequest)request, (String)"format");
        if (format.equals("raw")) {
            response.setContentType("text/plain");
            String outputStream = responseJSONObject.getString("output");
            ServletResponseUtil.write((HttpServletResponse)response, (String)outputStream);
        } else {
            response.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)response, (String)responseJSONObject.toString());
        }
    }
}

