/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.security.permission.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.service.SegmentsEntryRoleLocalService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={RoleContributor.class})
public class SegmentsEntryRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRoleContributor.class);
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsConfigurationProvider _segmentsConfigurationProvider;
    @Reference
    private SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsEntryRoleLocalService _segmentsEntryRoleLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contribute(RoleCollection roleCollection) {
        try {
            if (!this._segmentsConfigurationProvider.isRoleSegmentationEnabled(roleCollection.getCompanyId())) {
                return;
            }
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
            return;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            if (permissionChecker != null) {
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)new LiberalPermissionChecker(permissionChecker.getUser()));
            }
            for (long segmentsEntryId : this._getSegmentsEntryIds(roleCollection)) {
                List segmentsEntryRoles = this._segmentsEntryRoleLocalService.getSegmentsEntryRoles(segmentsEntryId);
                for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
                    roleCollection.addRoleId(segmentsEntryRole.getRoleId());
                }
            }
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private long[] _getSegmentsEntryIds(RoleCollection roleCollection) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return new long[0];
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return new long[0];
        }
        long[] cachedSegmentsEntryIds = (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS");
        if (cachedSegmentsEntryIds != null) {
            return cachedSegmentsEntryIds;
        }
        User user = roleCollection.getUser();
        long[] segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(roleCollection.getGroupId(), user.getUserId(), this._requestContextMapper.map(httpServletRequest), new long[0]);
        if (segmentsEntryIds.length > 0 && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Found segments ", segmentsEntryIds, " for user ", user.getUserId(), " in group ", roleCollection.getGroupId()}));
        }
        httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
        return segmentsEntryIds;
    }

    private class LiberalPermissionChecker
    implements PermissionChecker {
        private Role _ownerRole;
        private User _user;

        public PermissionChecker clone() {
            return this;
        }

        public long getCompanyId() {
            return this._user.getCompanyId();
        }

        public long[] getGuestUserRoleIds() {
            return PermissionChecker.DEFAULT_ROLE_IDS;
        }

        public long getOwnerRoleId() {
            return this._ownerRole.getRoleId();
        }

        public Map<Object, Object> getPermissionChecksMap() {
            return new HashMap<Object, Object>();
        }

        public long[] getRoleIds(long userId, long groupId) {
            return PermissionChecker.DEFAULT_ROLE_IDS;
        }

        public User getUser() {
            return this._user;
        }

        public UserBag getUserBag() {
            return null;
        }

        public long getUserId() {
            return this._user.getUserId();
        }

        public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
            return true;
        }

        public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
            return true;
        }

        public boolean hasPermission(Group group, String name, long primKey, String actionId) {
            return true;
        }

        public boolean hasPermission(Group group, String name, String primKey, String actionId) {
            return true;
        }

        public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
            return true;
        }

        public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
            return true;
        }

        public void init(User user) {
            this._user = user;
            try {
                this._ownerRole = SegmentsEntryRoleContributor.this._roleLocalService.getRole(user.getCompanyId(), "Owner");
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }

        public boolean isCheckGuest() {
            return PropsValues.PERMISSIONS_CHECK_GUEST_ENABLED;
        }

        public boolean isCompanyAdmin() {
            return true;
        }

        public boolean isCompanyAdmin(long companyId) {
            return true;
        }

        public boolean isContentReviewer(long companyId, long groupId) {
            return true;
        }

        public boolean isGroupAdmin(long groupId) {
            return true;
        }

        public boolean isGroupMember(long groupId) {
            return true;
        }

        public boolean isGroupOwner(long groupId) {
            return true;
        }

        public boolean isOmniadmin() {
            return true;
        }

        public boolean isOrganizationAdmin(long organizationId) {
            return true;
        }

        public boolean isOrganizationOwner(long organizationId) {
            return true;
        }

        public boolean isSignedIn() {
            return true;
        }

        private LiberalPermissionChecker(User user) {
            this.init(user);
        }
    }
}

