/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.configuration.provider;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.configuration.SegmentsCompanyConfiguration;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import jakarta.portlet.PortletURL;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={SegmentsConfigurationProvider.class})
public class SegmentsConfigurationProviderImpl
implements SegmentsConfigurationProvider {
    private final Map<String, Long> _companyIds = new ConcurrentHashMap<String, Long>();
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    private final Map<Long, String> _pids = new ConcurrentHashMap<Long, String>();
    @Reference
    private Portal _portal;
    private final Map<Long, SegmentsCompanyConfiguration> _segmentsCompanyConfigurations = new ConcurrentHashMap<Long, SegmentsCompanyConfiguration>();
    private volatile SegmentsConfiguration _segmentsConfiguration;
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;

    public void clearSegmentsCompanyConfigurations() {
        this._companyIds.clear();
        this._pids.clear();
        this._segmentsCompanyConfigurations.clear();
    }

    public String getCompanyConfigurationURL(HttpServletRequest httpServletRequest) throws PortalException {
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest));
        if (permissionChecker.isCompanyAdmin()) {
            String factoryPid;
            String pid = factoryPid = SegmentsCompanyConfiguration.class.getName();
            SegmentsCompanyConfiguration segmentsCompanyConfiguration = this._segmentsCompanyConfigurations.getOrDefault(this._portal.getCompanyId(httpServletRequest), (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, this._portal.getCompanyId(httpServletRequest)));
            if (segmentsCompanyConfiguration != null) {
                pid = this._pids.get(this._portal.getCompanyId(httpServletRequest));
            }
            return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_configuration_admin_web_portlet_InstanceSettingsPortlet", "RENDER_PHASE")).setMVCRenderCommandName("/configuration_admin/edit_configuration").setRedirect(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL", (String)this._portal.getCurrentCompleteURL(httpServletRequest))).setParameter("factoryPid", factoryPid).setParameter("pid", pid).buildString();
        }
        return null;
    }

    public String getConfigurationURL(HttpServletRequest httpServletRequest) throws PortalException {
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest));
        if (!permissionChecker.isOmniadmin()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, "com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "RENDER_PHASE")).setMVCRenderCommandName("/configuration_admin/edit_configuration").setRedirect(this._portal.getCurrentCompleteURL(httpServletRequest)).setParameter("factoryPid", SegmentsConfiguration.class.getName()).buildString();
    }

    public boolean isRoleSegmentationEnabled() throws ConfigurationException {
        return this._segmentsConfiguration.roleSegmentationEnabled();
    }

    public boolean isRoleSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.roleSegmentationEnabled()) {
            return false;
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = this._segmentsCompanyConfigurations.getOrDefault(companyId, (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId));
        if (segmentsCompanyConfiguration == null) {
            return this._segmentsConfiguration.roleSegmentationEnabled();
        }
        return segmentsCompanyConfiguration.roleSegmentationEnabled();
    }

    public boolean isSegmentationEnabled() throws ConfigurationException {
        return this._segmentsConfiguration.segmentationEnabled();
    }

    public boolean isSegmentationEnabled(long companyId) throws ConfigurationException {
        if (!this._segmentsConfiguration.segmentationEnabled()) {
            return false;
        }
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = this._segmentsCompanyConfigurations.getOrDefault(companyId, (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId));
        if (segmentsCompanyConfiguration == null) {
            return this._segmentsConfiguration.segmentationEnabled();
        }
        return segmentsCompanyConfiguration.segmentationEnabled();
    }

    public boolean isSegmentsCompanyConfigurationDefined(long companyId) throws ConfigurationException {
        SegmentsCompanyConfiguration segmentsCompanyConfiguration = this._segmentsCompanyConfigurations.getOrDefault(companyId, (SegmentsCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId));
        return segmentsCompanyConfiguration != null;
    }

    public void resetSegmentsCompanyConfiguration(long companyId) throws ConfigurationException {
        this._configurationProvider.deleteCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId);
    }

    public void updateSegmentsCompanyConfiguration(long companyId, SegmentsCompanyConfiguration segmentsCompanyConfiguration) throws ConfigurationException {
        this._configurationProvider.saveCompanyConfiguration(SegmentsCompanyConfiguration.class, companyId, (Dictionary)HashMapDictionaryBuilder.put((Object)"roleSegmentationEnabled", (Object)segmentsCompanyConfiguration.roleSegmentationEnabled()).put((Object)"segmentationEnabled", (Object)segmentsCompanyConfiguration.segmentationEnabled()).build());
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new SegmentsCompanyConfigurationManagedServiceFactory(), (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)"com.liferay.segments.configuration.SegmentsCompanyConfiguration.scoped").build());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
    }

    private void _unmapPid(String pid) {
        Long companyId = this._companyIds.remove(pid);
        if (companyId != null) {
            this._pids.remove(companyId);
            this._segmentsCompanyConfigurations.remove(companyId);
        }
    }

    private class SegmentsCompanyConfigurationManagedServiceFactory
    implements ManagedServiceFactory {
        private SegmentsCompanyConfigurationManagedServiceFactory() {
        }

        public void deleted(String pid) {
            SegmentsConfigurationProviderImpl.this._unmapPid(pid);
        }

        public String getName() {
            return "com.liferay.segments.configuration.SegmentsCompanyConfiguration.scoped";
        }

        public void updated(String pid, Dictionary<String, ?> dictionary) {
            SegmentsConfigurationProviderImpl.this._unmapPid(pid);
            long companyId = GetterUtil.getLong(dictionary.get("companyId"), (long)0L);
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
                if (companyId != 0L) {
                    SegmentsConfigurationProviderImpl.this._segmentsCompanyConfigurations.put(companyId, (SegmentsCompanyConfiguration)ConfigurableUtil.createConfigurable(SegmentsCompanyConfiguration.class, dictionary));
                    SegmentsConfigurationProviderImpl.this._companyIds.put(pid, companyId);
                    SegmentsConfigurationProviderImpl.this._pids.put(companyId, pid);
                }
            }
        }
    }
}

