/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.checker;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;

public class UserSegmentsEntryMembershipChecker {
    private static final String[] _DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
    private static final Map<String, Class<?>> _cachedScriptClasses = new ConcurrentHashMap();
    private static final Pattern _containsOperationPattern = Pattern.compile("contains\\(((?:customField/)?\\w*), '([^')]*)'\\)");
    private static final DateFormat _dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Pattern _dateTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|((\\+|-)(\\d*))){0,1}");
    private static final Map<String, String> _fieldNames = HashMapBuilder.put((Object)"dateModified", (Object)"modifiedDate").build();
    private static final GroovyShell _groovyShell = new GroovyShell(new CompilerConfiguration(){
        {
            this.addCompilationCustomizers(new CompilationCustomizer[]{new SecureASTCustomizer(){
                {
                    this.setImportsWhitelist(Collections.emptyList());
                    this.setReceiversWhiteList(List.of(Date.class.getName(), Object.class.getName(), String.class.getName()));
                    this.setTokensWhitelist(List.of(123, 126, 127, 124, 125, 120, 530, 611, 573, 544, 610, 50, 30, 164, 162, 160, 60, 40));
                }
            }});
        }
    });
    private static final Map<String, Object> _locks = new ConcurrentHashMap<String, Object>();
    private static final Pattern _logicalOperationPattern = Pattern.compile("\\s+(and|or)\\s+");
    private static final Pattern _notOperationPattern = Pattern.compile("not(?=\\s*\\()");
    private static final Pattern _operationPattern = Pattern.compile(StringBundler.concat((String[])new String[]{"((?:customField/)?\\w*)\\s+(eq|ge|gt|in|le|lt)\\s+", "('([^')]*)'|\\('([^')]*)'\\)|false|true|CLASS_PK|", "\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|", "((\\+|\\-)(\\d*))){0,1})"}));
    private static final Map<String, String> _operators = HashMapBuilder.put((Object)"and", (Object)"&&").put((Object)"eq", (Object)"==").put((Object)"ge", (Object)">=").put((Object)"gt", (Object)">").put((Object)"le", (Object)"<=").put((Object)"lt", (Object)"<").put((Object)"not", (Object)"!").put((Object)"or", (Object)"||").build();
    private static final Pattern _valuePattern = Pattern.compile("'([^')]*)'|false|true|CLASS_PK|'{0,1}\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|((\\+|-)(\\d*))){0,1}'{0,1}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMember(String filterString, Map<String, Object> userAttributes) {
        String template = UserSegmentsEntryMembershipChecker._buildGroovyTemplate(filterString);
        Class clazz = _cachedScriptClasses.get(template);
        if (clazz == null) {
            Object lock;
            Object object = lock = _locks.computeIfAbsent(template, o -> new Object());
            synchronized (object) {
                clazz = _cachedScriptClasses.computeIfAbsent(template, arg_0 -> ((GroovyClassLoader)_groovyShell.getClassLoader()).parseClass(arg_0));
            }
        }
        Script script = null;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            script = (Script)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to evaluate filter: " + filterString, exception);
        }
        Binding binding = new Binding();
        binding.setVariable("CLASS_PK", (Object)String.valueOf(userAttributes.get("classPK")));
        binding.setVariable("user", UserSegmentsEntryMembershipChecker._getFilteredUserAttributes(userAttributes));
        script.setBinding(binding);
        return (Boolean)script.invokeMethod("evaluate", null);
    }

    private static String _buildGroovyTemplate(String filterString) {
        String parsedFilterString = filterString;
        parsedFilterString = UserSegmentsEntryMembershipChecker._processContainsOperations(parsedFilterString);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processLogicalOperations(parsedFilterString);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processNotOperations(parsedFilterString);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processOperations(parsedFilterString);
        return "def evaluate() {return " + parsedFilterString + " }";
    }

    private static String _getDateValueString(String input) throws Exception {
        Matcher matcher = _dateTimePattern.matcher(input);
        if (matcher.find()) {
            String group = matcher.group();
            return _dateTimeFormat.format(DateUtils.parseDate((String)group, (String[])_DATE_PATTERNS));
        }
        return null;
    }

    private static String _getFieldName(String key) {
        String fieldName = _fieldNames.get(StringUtil.trim((String)key));
        if (fieldName != null) {
            return fieldName;
        }
        return key;
    }

    private static Object _getFieldValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof Date) {
            return value;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                list.add(UserSegmentsEntryMembershipChecker._getFieldValue(Array.get(value, i)));
            }
            return list.toArray();
        }
        if (Validator.isBlank((String)value.toString())) {
            return null;
        }
        return StringUtil.lowerCase((String)value.toString());
    }

    private static Map<String, Object> _getFilteredUserAttributes(Map<String, Object> userAttributes) {
        HashMap<String, Object> filteredUserAttributes = new HashMap<String, Object>();
        userAttributes.forEach((key, value) -> {
            Object fieldValue = UserSegmentsEntryMembershipChecker._getFieldValue(value);
            if (Validator.isNotNull((Object)fieldValue)) {
                filteredUserAttributes.put((String)key, fieldValue);
            }
        });
        return filteredUserAttributes;
    }

    private static String _getValue(String input) {
        Matcher matcher = _valuePattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static String _processContainsOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _containsOperationPattern.matcher(filterString);
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            String value = StringUtil.lowerCase((String)matcher.group(2));
            String replacement = StringBundler.concat((String[])new String[]{"((user['", UserSegmentsEntryMembershipChecker._getFieldName(fieldName), "']?.toLowerCase().indexOf('", value, "') != null ? user['", UserSegmentsEntryMembershipChecker._getFieldName(fieldName), "'].toLowerCase().indexOf('", value, "') : -1) >= 0)"});
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processLogicalOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _logicalOperationPattern.matcher(filterString);
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(sb, StringUtil.quote((String)_operators.get(StringUtil.trim((String)group)), (String)" "));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processNotOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _notOperationPattern.matcher(filterString);
        while (matcher.find()) {
            matcher.appendReplacement(sb, "!");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _operationPattern.matcher(filterString);
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            String operator = matcher.group(2);
            String value = UserSegmentsEntryMembershipChecker._getValue(String.valueOf(matcher.group(3)));
            if (value == null || Validator.isBlank((String)operator) || Validator.isBlank((String)value)) continue;
            try {
                if (UserSegmentsEntryMembershipChecker._getDateValueString(value) != null) {
                    value = StringBundler.concat((String[])new String[]{"Date.parse(\"yyyy-MM-dd'T'HH:mm:ss.SSSX\", \"", value, "\")"});
                } else if (!StringUtil.equals((String)value, (String)"CLASS_PK")) {
                    value = StringUtil.lowerCase((String)value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            matcher.appendReplacement(sb, StringBundler.concat((String[])new String[]{"(user['", UserSegmentsEntryMembershipChecker._getFieldName(fieldName), "'] instanceof Object[] ? ", value, " in user['", UserSegmentsEntryMembershipChecker._getFieldName(fieldName), "'] : user['", UserSegmentsEntryMembershipChecker._getFieldName(fieldName), "'] ", _operators.getOrDefault(operator, operator), " ", value, ")"}));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

