/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.context.Context;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributorRegistry;
import com.liferay.segments.internal.checker.UserSegmentsEntryMembershipChecker;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.odata.matcher.ODataMatcher;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSegmentsEntryProvider
implements SegmentsEntryProvider {
    @Reference
    protected AssetCategoryLocalService assetCategoryLocalService;
    @Reference
    protected AssetTagLocalService assetTagLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ExpandoColumnLocalService expandoColumnLocalService;
    @Reference
    protected ExpandoTableLocalService expandoTableLocalService;
    @Reference
    protected ExpandoValueLocalService expandoValueLocalService;
    @Reference(target="(target.class.name=com.liferay.segments.context.Context)")
    protected ODataMatcher<Context> oDataMatcher;
    @Reference
    protected Portal portal;
    @Reference
    protected SegmentsCriteriaContributorRegistry segmentsCriteriaContributorRegistry;
    @Reference
    protected SegmentsEntryLocalService segmentsEntryLocalService;
    @Reference
    protected SegmentsEntryRelLocalService segmentsEntryRelLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    protected ODataRetriever<User> userODataRetriever;
    private static final Log _log = LogFactoryUtil.getLog(BaseSegmentsEntryProvider.class);

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return new long[0];
        }
        String filterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            return TransformUtil.transformToLongArray((Collection)this.segmentsEntryRelLocalService.getSegmentsEntryRels(segmentsEntryId, start, end, null), SegmentsEntryRelModel::getClassPK);
        }
        return TransformUtil.transformToLongArray((Collection)this.userODataRetriever.getResults(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault(), start, end), baseModel -> (Long)baseModel.getPrimaryKeyObj());
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return 0;
        }
        String filterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            return this.segmentsEntryRelLocalService.getSegmentsEntryRelsCount(segmentsEntryId);
        }
        return this.userODataRetriever.getResultsCount(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault());
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context) throws PortalException {
        return this.getSegmentsEntryIds(groupId, className, classPK, context, new long[0], new long[0]);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context, long[] filterSegmentsEntryIds, long[] segmentsEntryIds) {
        List segmentsEntries = new ArrayList();
        segmentsEntries = ArrayUtil.isNotEmpty((long[])filterSegmentsEntryIds) ? this.segmentsEntryLocalService.getSegmentsEntries(filterSegmentsEntryIds, -1, -1) : this.segmentsEntryLocalService.getSegmentsEntries(groupId, this.getSource(), -1, -1, null);
        if (segmentsEntries.isEmpty()) {
            return new long[0];
        }
        User user = this.userLocalService.fetchUser(classPK);
        if (user == null || user.getType() == 2) {
            return new long[0];
        }
        try {
            Map<String, Object> userAttributes = this._getUserAttributes(user);
            return TransformUtil.transformToLongArray(segmentsEntries, segmentsEntry -> {
                if (this.isMember(className, classPK, context, (SegmentsEntry)segmentsEntry, segmentsEntryIds, userAttributes)) {
                    return segmentsEntry.getSegmentsEntryId();
                }
                return null;
            });
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return new long[0];
        }
    }

    protected Criteria.Conjunction getConjunction(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return Criteria.Conjunction.AND;
        }
        return existingCriteria.getTypeConjunction(type);
    }

    protected String getFilterString(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return null;
        }
        Criteria criteria = new Criteria();
        for (SegmentsCriteriaContributor segmentsCriteriaContributor : this.segmentsCriteriaContributorRegistry.getSegmentsCriteriaContributors()) {
            Criteria.Criterion criterion = segmentsCriteriaContributor.getCriterion(existingCriteria);
            if (criterion == null) continue;
            segmentsCriteriaContributor.contribute(criteria, criterion.getFilterString(), Criteria.Conjunction.parse((String)criterion.getConjunction()));
        }
        return criteria.getFilterString(type);
    }

    protected abstract String getSource();

    protected boolean isMember(String className, long classPK, Context context, SegmentsEntry segmentsEntry, long[] segmentsEntryIds, Map<String, Object> userAttributes) {
        String contextFilterString = this.getFilterString(segmentsEntry, Criteria.Type.CONTEXT);
        String modelFilterString = this.getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (ArrayUtil.contains((long[])((long[])userAttributes.get("segmentsEntryIds")), (long)segmentsEntry.getSegmentsEntryId()) && Validator.isNull((String)contextFilterString) && Validator.isNull((String)modelFilterString)) {
            return true;
        }
        Criteria criteria = segmentsEntry.getCriteriaObj();
        if (criteria == null || MapUtil.isEmpty((Map)criteria.getCriteria())) {
            return false;
        }
        Criteria.Conjunction contextConjunction = this.getConjunction(segmentsEntry, Criteria.Type.CONTEXT);
        if (context != null && Validator.isNotNull((String)contextFilterString)) {
            boolean matchesContext;
            boolean guestUser;
            block14: {
                boolean bl = guestUser = !GetterUtil.getBoolean((Object)context.get((Object)"signedIn"), (boolean)true);
                if (contextConjunction.equals((Object)Criteria.Conjunction.AND) && guestUser && Validator.isNotNull((String)modelFilterString)) {
                    return false;
                }
                matchesContext = false;
                try {
                    matchesContext = this.oDataMatcher.matches(contextFilterString, (Object)context);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Throwable)portalException);
                }
            }
            if (matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.OR)) {
                return true;
            }
            if (!matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.AND)) {
                return false;
            }
            if (guestUser) {
                return matchesContext;
            }
        }
        if (Validator.isNotNull((String)modelFilterString)) {
            boolean matchesModel = false;
            try {
                matchesModel = UserSegmentsEntryMembershipChecker.isMember(StringBundler.concat((String[])new String[]{"(", modelFilterString, ") and (classPK eq CLASS_PK)"}), userAttributes);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            Criteria.Conjunction modelConjunction = this.getConjunction(segmentsEntry, Criteria.Type.MODEL);
            if (matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.OR)) {
                return true;
            }
            if (!matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.AND)) {
                return false;
            }
        }
        return true;
    }

    private long[] _getSegmentsEntryIds(User user) throws Exception {
        return TransformUtil.transformToLongArray((Collection)this.segmentsEntryRelLocalService.getSegmentsEntryRels(this.portal.getClassNameId(User.class), user.getUserId()), SegmentsEntryRelModel::getSegmentsEntryId);
    }

    private Map<String, Object> _getUserAttributes(User user) throws Exception {
        HashMap<String, String> expandoValues = new HashMap<String, String>();
        ExpandoTable expandoTable = this.expandoTableLocalService.fetchTable(user.getCompanyId(), this.classNameLocalService.getClassNameId(User.class.getName()), "CUSTOM_FIELDS");
        if (expandoTable != null) {
            List expandoColumns = this.expandoColumnLocalService.getColumns(expandoTable.getTableId());
            for (ExpandoColumn expandoColumn : expandoColumns) {
                ExpandoValue expandoValue = this.expandoValueLocalService.getValue(expandoTable.getTableId(), expandoColumn.getColumnId(), user.getUserId());
                String expandoColumnName = expandoColumn.getName();
                String key = StringBundler.concat((Object[])new Object[]{"customField/_", expandoColumn.getColumnId(), "_", StringUtil.replace((String)expandoColumnName.replaceAll(":|;|'|\"", ""), (char)' ', (char)'_')});
                if (expandoValue != null) {
                    expandoValues.put(key, expandoValue.getData());
                    continue;
                }
                expandoValues.put(key, "");
            }
        }
        return HashMapBuilder.putAll((Map)user.getModelAttributes()).putAll(expandoValues).put((Object)"assetCategoryIds", (Object)TransformUtil.transform((Collection)this.assetCategoryLocalService.getCategories(this.portal.getClassNameId(User.class), user.getUserId()), assetCategory -> assetCategory.getCategoryId()).toArray(new Long[0])).put((Object)"assetTagIds", (Object)TransformUtil.transform((Collection)this.assetTagLocalService.getTags(this.portal.getClassNameId(User.class), user.getUserId()), assetTag -> assetTag.getTagId()).toArray(new Long[0])).put((Object)"birthDate", () -> {
            try {
                return user.getBirthday();
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return new Date(0L);
            }
        }).put((Object)"classPK", (Object)user.getUserId()).put((Object)"groupIds", (Object)user.getGroupIds()).put((Object)"organizationIds", (Object)user.getOrganizationIds()).put((Object)"roleIds", (Object)user.getRoleIds()).put((Object)"segmentsEntryIds", (Object)this._getSegmentsEntryIds(user)).put((Object)"teamIds", (Object)user.getTeamIds()).put((Object)"userGroupIds", (Object)user.getUserGroupIds()).put((Object)"userGroupRoleIds", (Object)TransformUtil.transform((Collection)user.getUserGroupRoles(), role -> role.getRoleId()).toArray(new Long[0])).build();
    }
}

